/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.jsimpledb.AnnotationScanner;
import org.jsimpledb.JClass;
import org.jsimpledb.Util;
import org.jsimpledb.annotation.JSimpleClass;
import org.jsimpledb.annotation.JTransient;

abstract class AbstractFieldScanner<T, A extends Annotation>
extends AnnotationScanner<T, A> {
    protected final JSimpleClass jsimpleClass;

    AbstractFieldScanner(JClass<T> jclass, Class<A> annotationType, JSimpleClass jsimpleClass) {
        super(jclass, annotationType);
        this.jsimpleClass = jsimpleClass;
    }

    protected abstract A getDefaultAnnotation();

    @Override
    protected A getAnnotation(Method method) {
        Object annotation = super.getAnnotation(method);
        if (annotation != null) {
            return annotation;
        }
        if (!this.hasAnnotatedOverriddenMethod(method.getDeclaringClass(), method.getName(), method.getParameterTypes()) && this.isAutoPropertyCandidate(method)) {
            return this.getDefaultAnnotation();
        }
        return null;
    }

    protected boolean hasAnnotatedOverriddenMethod(Class<?> klass, String name, Class<?>[] parameterTypes) {
        if (this.hasAnnotatedMethod(klass, name, parameterTypes)) {
            return true;
        }
        for (Class<?> iface : klass.getInterfaces()) {
            if (!this.hasAnnotatedMethod(iface, name, parameterTypes)) continue;
            return true;
        }
        Class<?> superclass = klass.getSuperclass();
        return superclass != null && this.hasAnnotatedOverriddenMethod(superclass, name, parameterTypes);
    }

    private boolean hasAnnotatedMethod(Class<?> klass, String name, Class<?>[] parameterTypes) {
        try {
            return klass.getMethod(name, parameterTypes).isAnnotationPresent(this.annotationType);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    protected boolean isAutoPropertyCandidate(Method method) {
        if (!this.jsimpleClass.autogenFields()) {
            return false;
        }
        if ((method.getModifiers() & 8) != 0) {
            return false;
        }
        if (this.hasJTransientAnnotation(method)) {
            return false;
        }
        if (!this.jsimpleClass.autogenNonAbstract() && this.isOverriddenByConcreteMethod(method)) {
            return false;
        }
        if ((method.getModifiers() & 5) == 0) {
            return false;
        }
        if ((method.getModifiers() & 2) != 0) {
            return false;
        }
        if (!Pattern.compile("(is|get)(.+)").matcher(method.getName()).matches()) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return method.getReturnType() != Void.TYPE;
    }

    private boolean isOverriddenByConcreteMethod(Method method) {
        if ((method.getModifiers() & 0x400) == 0) {
            return true;
        }
        Class<?> methodType = method.getDeclaringClass();
        for (TypeToken typeToken : TypeToken.of(this.jclass.type).getTypes()) {
            Method otherMethod;
            Class type = typeToken.getRawType();
            if (!methodType.isAssignableFrom(type) || type.equals(methodType)) continue;
            try {
                otherMethod = type.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            if ((otherMethod.getModifiers() & 0x400) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasJTransientAnnotation(Method method) {
        String name = method.getName();
        Class<?>[] ptypes = method.getParameterTypes();
        for (TypeToken typeToken : TypeToken.of(method.getDeclaringClass()).getTypes()) {
            Method override;
            try {
                override = typeToken.getRawType().getDeclaredMethod(name, ptypes);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            if (Util.getAnnotation(override, JTransient.class) == null) continue;
            return true;
        }
        return false;
    }
}

