/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.dellroad.stuff.java.MethodAnnotationScanner;
import org.jsimpledb.JClass;
import org.jsimpledb.Util;

abstract class AnnotationScanner<T, A extends Annotation>
extends MethodAnnotationScanner<T, A> {
    protected final JClass<T> jclass;

    protected AnnotationScanner(JClass<T> jclass, Class<A> annotationType) {
        super(jclass.getType(), annotationType);
        this.jclass = jclass;
    }

    protected AnnotationScanner(Class<T> type, Class<A> annotationType) {
        super(type, annotationType);
        this.jclass = null;
    }

    protected A getAnnotation(Method method) {
        return Util.getAnnotation(method, this.annotationType);
    }

    public String getAnnotationDescription() {
        return "@" + this.annotationType.getSimpleName();
    }

    protected void checkNotStatic(Method method) {
        if ((method.getModifiers() & 8) != 0) {
            throw new IllegalArgumentException(this.getErrorPrefix(method) + "annotation is not supported on static methods");
        }
    }

    protected void checkReturnType(Method method, List<TypeToken<?>> expecteds) {
        TypeToken actual = TypeToken.of((Type)method.getGenericReturnType());
        for (TypeToken<?> expected : expecteds) {
            if (!actual.equals(expected)) continue;
            return;
        }
        throw new IllegalArgumentException(this.getErrorPrefix(method) + "method is required to return " + (expecteds.size() != 1 ? "one of " + expecteds : (Serializable)expecteds.get(0)) + " but instead returns " + actual);
    }

    protected void checkReturnType(Method method, Class<?> ... expecteds) {
        Class<?> actual = method.getReturnType();
        for (Class<?> expected : expecteds) {
            if (!actual.equals(expected)) continue;
            return;
        }
        throw new IllegalArgumentException(this.getErrorPrefix(method) + "method is required to return " + (expecteds.length != 1 ? "one of " + Arrays.asList(expecteds) : expecteds[0]) + " but instead returns " + actual);
    }

    protected void checkParameterTypes(Method method, List<TypeToken<?>> expected) {
        List<TypeToken<?>> actual = this.getParameterTypeTokens(method);
        if (!actual.equals(expected)) {
            throw new IllegalArgumentException(this.getErrorPrefix(method) + "method is required to take " + (expected.isEmpty() ? "zero parameters" : expected.size() + " parameter(s) of type " + expected));
        }
    }

    protected void checkParameterTypes(Method method, TypeToken<?> ... expected) {
        this.checkParameterTypes(method, Arrays.asList(expected));
    }

    protected void checkParameterType(Method method, int index, List<TypeToken<?>> choices) {
        List<TypeToken<?>> actuals = this.getParameterTypeTokens(method);
        if (actuals.size() <= index || !choices.contains(actuals.get(index))) {
            throw new IllegalArgumentException(this.getErrorPrefix(method) + "method parameter #" + (index + 1) + " is required to have type " + (choices.size() != 1 ? "one of " + choices : (Serializable)choices.get(0)));
        }
    }

    protected void checkParameterType(Method method, int index, TypeToken<?> ... choices) {
        this.checkParameterType(method, index, Arrays.asList(choices));
    }

    protected void checkSingleParameterType(Method method, List<TypeToken<?>> choices) {
        List<TypeToken<?>> actuals = this.getParameterTypeTokens(method);
        if (actuals.size() != 1 || !choices.contains(actuals.get(0))) {
            throw new IllegalArgumentException(this.getErrorPrefix(method) + "method is required to take a single parameter with type " + (choices.size() != 1 ? "one of " + choices : (Serializable)choices.get(0)));
        }
    }

    protected List<TypeToken<?>> getParameterTypeTokens(Method method) {
        return Lists.transform(Arrays.asList(method.getGenericParameterTypes()), TypeToken::of);
    }

    protected String getErrorPrefix(Method method) {
        return "invalid " + this.getAnnotationDescription() + " annotation on method " + method + " for type `" + this.jclass.getName() + "': ";
    }
}

