/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.SortedSet;
import org.dellroad.stuff.java.MethodAnnotationScanner;
import org.dellroad.stuff.java.Primitive;
import org.jsimpledb.EnumConverter;
import org.jsimpledb.FollowPathScanner;
import org.jsimpledb.JClass;
import org.jsimpledb.JField;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.ReferencePath;
import org.jsimpledb.annotation.FollowPath;
import org.jsimpledb.asm.ClassWriter;
import org.jsimpledb.asm.FieldVisitor;
import org.jsimpledb.asm.Label;
import org.jsimpledb.asm.MethodVisitor;
import org.jsimpledb.asm.Type;
import org.jsimpledb.core.DatabaseException;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassGenerator<T> {
    static final String GEN_SOURCE = "[GeneratedByJSimpleDB]";
    static final String TX_FIELD_NAME = "$tx";
    static final String ID_FIELD_NAME = "$id";
    static final String CACHED_VALUE_FIELD_PREFIX = "$cached_";
    static final String CACHED_FLAG_FIELD_PREFIX = "$cacheflags";
    static final String ENUM_CONVERTER_FIELD_PREFIX = "$ec";
    static final String FOLLOW_PATH_FIELD_PREFIX = "$followPath";
    static final Method JOBJECT_GET_OBJ_ID_METHOD;
    static final Method JOBJECT_GET_TRANSACTION;
    static final Method JOBJECT_GET_MODEL_CLASS;
    static final Method JOBJECT_RESET_CACHED_FIELD_VALUES_METHOD;
    static final Method JTRANSACTION_READ_COUNTER_FIELD_METHOD;
    static final Method JTRANSACTION_READ_SET_FIELD_METHOD;
    static final Method JTRANSACTION_READ_LIST_FIELD_METHOD;
    static final Method JTRANSACTION_READ_MAP_FIELD_METHOD;
    static final Method JTRANSACTION_GET_TRANSACTION_METHOD;
    static final Method JTRANSACTION_GET_METHOD;
    static final Method JTRANSACTION_REGISTER_JOBJECT_METHOD;
    static final Method JTRANSACTION_GET_JSIMPLEDB_METHOD;
    static final Method JTRANSACTION_FOLLOW_REFERENCE_PATH_METHOD;
    static final Method JTRANSACTION_INVERT_REFERENCE_PATH_METHOD;
    static final Method JSIMPLEDB_PARSE_REFERENCE_PATH_METHOD;
    static final Method CONVERTER_CONVERT_METHOD;
    static final Method CONVERTER_REVERSE_METHOD;
    static final Method ENUM_CONVERTER_CREATE_METHOD;
    static final Method TRANSACTION_READ_SIMPLE_FIELD_METHOD;
    static final Method TRANSACTION_WRITE_SIMPLE_FIELD_METHOD;
    static final Method COLLECTIONS_SINGLETON_METHOD;
    static final Method OPTIONAL_OF_METHOD;
    static final Method OPTIONAL_EMPTY_METHOD;
    static final Method SORTED_SET_FIRST_METHOD;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final JSimpleDB jdb;
    protected final JClass<T> jclass;
    protected final Class<T> modelClass;
    private Class<? extends T> subclass;
    private Constructor<? extends T> constructor;
    private Constructor<? super T> superclassConstructor;

    ClassGenerator(JClass<T> jclass) {
        this(jclass.jdb, jclass, jclass.type);
    }

    ClassGenerator(JSimpleDB jdb, Class<T> modelClass) {
        this(jdb, null, modelClass);
    }

    private ClassGenerator(JSimpleDB jdb, JClass<T> jclass, Class<T> modelClass) {
        this.jdb = jdb;
        this.jclass = jclass;
        this.modelClass = modelClass;
        if (this.modelClass.isInterface()) {
            try {
                this.superclassConstructor = Object.class.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("unexpected exception", e);
            }
        }
        try {
            this.superclassConstructor = this.modelClass.getDeclaredConstructor(JTransaction.class, ObjId.class);
        }
        catch (NoSuchMethodException e) {
            try {
                this.superclassConstructor = this.modelClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                throw new IllegalArgumentException("no suitable constructor found in model class " + this.modelClass.getName() + "; model classes must have a public or protected constructor taking either () or (JTransaction, ObjId)");
            }
        }
        if ((this.superclassConstructor.getModifiers() & 5) == 0) {
            throw new IllegalArgumentException("model class " + this.modelClass.getName() + " constructor " + this.superclassConstructor + " is inaccessible; must be either public or protected");
        }
    }

    public Constructor<? extends T> getConstructor() {
        if (this.constructor == null) {
            if (this.subclass == null) {
                this.subclass = this.generateClass();
            }
            try {
                this.constructor = this.subclass.getConstructor(JTransaction.class, ObjId.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("internal error", e);
            }
            this.constructor.setAccessible(true);
        }
        return this.constructor;
    }

    public Class<? extends T> generateClass() {
        try {
            return Class.forName(this.getClassName().replace('/', '.'), true, this.jdb.loader);
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseException("internal error", (Throwable)e);
        }
    }

    public String getClassName() {
        return Type.getInternalName(this.modelClass) + "$$JSimpleDB";
    }

    public String getSuperclassName() {
        return Type.getInternalName(this.modelClass.isInterface() ? Object.class : this.modelClass);
    }

    protected byte[] generateBytecode() {
        String[] stringArray;
        this.log.debug("begin generating class " + this.getClassName());
        ClassWriter cw = new ClassWriter(1);
        if (this.modelClass.isInterface()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = Type.getInternalName(this.modelClass);
            stringArray = stringArray2;
            stringArray2[1] = Type.getInternalName(JObject.class);
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = Type.getInternalName(JObject.class);
        }
        String[] interfaces = stringArray;
        cw.visit(50, 4129, this.getClassName(), null, this.getSuperclassName(), interfaces);
        cw.visitSource(GEN_SOURCE, null);
        this.outputFields(cw);
        this.outputConstructors(cw);
        this.outputMethods(cw);
        cw.visitEnd();
        byte[] classfile = cw.toByteArray();
        this.log.debug("done generating class " + this.getClassName());
        this.debugDump(System.out, classfile);
        return classfile;
    }

    private void outputFields(ClassWriter cw) {
        cw.visitField(148, TX_FIELD_NAME, Type.getDescriptor(JTransaction.class), null, null).visitEnd();
        cw.visitField(20, ID_FIELD_NAME, Type.getDescriptor(ObjId.class), null, null).visitEnd();
        if (this.jclass != null) {
            for (JField jfield : this.jclass.jfields.values()) {
                jfield.outputFields(this, cw);
            }
        }
        if (this.jclass != null) {
            int[] simpleFieldStorageIds = this.jclass.simpleFieldStorageIds;
            String lastFieldName = null;
            for (int i = 0; i < simpleFieldStorageIds.length; ++i) {
                String fieldName = this.getCachedFlagFieldName(i);
                if (fieldName.equals(lastFieldName)) continue;
                FieldVisitor flagsField = cw.visitField(130, fieldName, Type.getDescriptor(this.getCachedFlagFieldType(i)), null, null);
                flagsField.visitEnd();
                lastFieldName = fieldName;
            }
        }
        if (this.jclass != null) {
            int fieldIndex = 0;
            for (MethodAnnotationScanner.MethodInfo info0 : this.jclass.followPathMethods) {
                FollowPathScanner.FollowPathMethodInfo info = (FollowPathScanner.FollowPathMethodInfo)info0;
                String fieldName = FOLLOW_PATH_FIELD_PREFIX + fieldIndex++;
                cw.visitField(10, fieldName, Type.getDescriptor(ReferencePath.class), null, null).visitEnd();
            }
        }
    }

    private void outputConstructors(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(JTransaction.class), Type.getType(ObjId.class)), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, this.getClassName(), ID_FIELD_NAME, Type.getDescriptor(ObjId.class));
        if (this.superclassConstructor.getParameterCount() > 0) {
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
        }
        this.emitInvoke(mv, this.superclassConstructor);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void outputMethods(ClassWriter cw) {
        Object simpleFieldStorageIds;
        if (this.jclass != null) {
            boolean needClassInitializer = false;
            for (JField jfield2 : this.jclass.jfields.values()) {
                if (!jfield2.hasClassInitializerBytecode()) continue;
                needClassInitializer = true;
                break;
            }
            if (needClassInitializer) {
                MethodVisitor mv = cw.visitMethod(10, "<clinit>", "()V", null, null);
                mv.visitCode();
                this.jclass.jfields.values().stream().filter(JField::hasClassInitializerBytecode).forEach(jfield -> jfield.outputClassInitializerBytecode(this, mv));
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
        }
        MethodVisitor mv = this.startMethod(cw, JOBJECT_GET_TRANSACTION);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.startMethod(cw, JOBJECT_GET_MODEL_CLASS);
        mv.visitCode();
        mv.visitLdcInsn(Type.getObjectType(Type.getInternalName(this.modelClass)));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.startMethod(cw, JOBJECT_GET_OBJ_ID_METHOD);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), ID_FIELD_NAME, Type.getDescriptor(ObjId.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.startMethod(cw, JOBJECT_RESET_CACHED_FIELD_VALUES_METHOD);
        mv.visitCode();
        if (this.jclass != null) {
            simpleFieldStorageIds = this.jclass.simpleFieldStorageIds;
            String lastFieldName = null;
            for (int i = 0; i < ((int[])simpleFieldStorageIds).length; ++i) {
                String fieldName = this.getCachedFlagFieldName(i);
                if (fieldName.equals(lastFieldName)) continue;
                mv.visitVarInsn(25, 0);
                mv.visitInsn(3);
                mv.visitFieldInsn(181, this.getClassName(), fieldName, Type.getDescriptor(this.getCachedFlagFieldType(i)));
                lastFieldName = fieldName;
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        if (this.jclass == null) {
            return;
        }
        simpleFieldStorageIds = this.jclass.jfields.values().iterator();
        while (simpleFieldStorageIds.hasNext()) {
            JField jfield2;
            jfield2 = (JField)simpleFieldStorageIds.next();
            jfield2.outputMethods(this, cw);
        }
        int fieldIndex = 0;
        for (MethodAnnotationScanner.MethodInfo info : this.jclass.followPathMethods) {
            this.addFollowPathMethod(cw, (FollowPathScanner.FollowPathMethodInfo)info, FOLLOW_PATH_FIELD_PREFIX + fieldIndex++);
        }
    }

    private void addFollowPathMethod(ClassWriter cw, FollowPathScanner.FollowPathMethodInfo info, String fieldName) {
        MethodVisitor mv = this.startMethod(cw, info.getMethod());
        mv.visitFieldInsn(178, this.getClassName(), fieldName, Type.getDescriptor(ReferencePath.class));
        Label gotPath = new Label();
        mv.visitJumpInsn(199, gotPath);
        ReferencePath path = info.getReferencePath();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        this.emitInvoke(mv, JTRANSACTION_GET_JSIMPLEDB_METHOD);
        mv.visitLdcInsn(Type.getObjectType(Type.getInternalName(path.getStartType())));
        mv.visitLdcInsn(path.toString());
        mv.visitInsn(3);
        this.emitInvoke(mv, JSIMPLEDB_PARSE_REFERENCE_PATH_METHOD);
        mv.visitFieldInsn(179, this.getClassName(), fieldName, Type.getDescriptor(ReferencePath.class));
        mv.visitLabel(gotPath);
        mv.visitFrame(3, 0, new Object[0], 0, new Object[0]);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        mv.visitFieldInsn(178, this.getClassName(), fieldName, Type.getDescriptor(ReferencePath.class));
        mv.visitVarInsn(25, 0);
        this.emitInvoke(mv, COLLECTIONS_SINGLETON_METHOD);
        this.emitInvoke(mv, info.isInverse() ? JTRANSACTION_INVERT_REFERENCE_PATH_METHOD : JTRANSACTION_FOLLOW_REFERENCE_PATH_METHOD);
        if (((FollowPath)info.getAnnotation()).firstOnly()) {
            Label tryStart = new Label();
            Label tryStop = new Label();
            Label catchLabel = new Label();
            mv.visitTryCatchBlock(tryStart, tryStop, catchLabel, Type.getInternalName(NoSuchElementException.class));
            mv.visitLabel(tryStart);
            this.emitInvoke(mv, SORTED_SET_FIRST_METHOD);
            mv.visitLabel(tryStop);
            this.emitInvoke(mv, OPTIONAL_OF_METHOD);
            mv.visitInsn(176);
            mv.visitLabel(catchLabel);
            this.emitInvoke(mv, OPTIONAL_EMPTY_METHOD);
            mv.visitInsn(176);
        } else {
            mv.visitInsn(176);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void debugDump(PrintStream out, byte[] classfile) {
    }

    void wrap(MethodVisitor mv, Primitive<?> primitive) {
        Type wrapperType = Type.getType(primitive.getWrapperType());
        mv.visitMethodInsn(184, wrapperType.getInternalName(), "valueOf", Type.getMethodDescriptor(wrapperType, Type.getType(primitive.getType())), false);
    }

    void unwrap(MethodVisitor mv, Primitive<?> primitive) {
        Method unwrapMethod = primitive.getUnwrapMethod();
        this.emitInvoke(mv, unwrapMethod);
    }

    void emitInvoke(MethodVisitor mv, Method method) {
        boolean isStatic;
        boolean isInterface = method.getDeclaringClass().isInterface();
        boolean bl = isStatic = (method.getModifiers() & 8) != 0;
        mv.visitMethodInsn(isInterface ? 185 : (isStatic ? 184 : 182), Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor(method), isInterface);
    }

    void emitInvoke(MethodVisitor mv, String className, Method method) {
        mv.visitMethodInsn(182, className, method.getName(), Type.getMethodDescriptor(method), false);
    }

    void emitInvoke(MethodVisitor mv, Constructor<?> constructor) {
        mv.visitMethodInsn(183, Type.getInternalName(constructor.getDeclaringClass()), "<init>", Type.getConstructorDescriptor(constructor), false);
    }

    MethodVisitor startMethod(ClassWriter cw, Method method) {
        return cw.visitMethod(method.getModifiers() & 7, method.getName(), Type.getMethodDescriptor(method), null, this.getExceptionNames(method));
    }

    String[] getExceptionNames(Method method) {
        ArrayList<String> list = new ArrayList<String>();
        for (Class<?> type : method.getExceptionTypes()) {
            list.add(Type.getType(type).getInternalName());
        }
        return list.toArray(new String[list.size()]);
    }

    String getCachedFlagFieldName(JSimpleField jfield) {
        return this.getCachedFlagFieldName(this.getCachedFlagIndex(jfield));
    }

    int getCachedFlagBit(JSimpleField jfield) {
        return 1 << this.getCachedFlagIndex(jfield) % 32;
    }

    Class<?> getCachedFlagFieldType(JSimpleField jfield) {
        return this.getCachedFlagFieldType(this.getCachedFlagIndex(jfield));
    }

    private Class<?> getCachedFlagFieldType(int simpleFieldIndex) {
        int numSimpleFields = this.jclass.simpleFieldStorageIds.length;
        Preconditions.checkArgument((simpleFieldIndex >= 0 && simpleFieldIndex < numSimpleFields ? 1 : 0) != 0);
        if (simpleFieldIndex / 32 < numSimpleFields / 32) {
            return Integer.TYPE;
        }
        int tail = numSimpleFields % 32;
        return tail <= 8 ? Byte.TYPE : (tail <= 16 ? Short.TYPE : Integer.TYPE);
    }

    private String getCachedFlagFieldName(int simpleFieldIndex) {
        Preconditions.checkArgument((simpleFieldIndex >= 0 && simpleFieldIndex < this.jclass.simpleFieldStorageIds.length ? 1 : 0) != 0);
        return CACHED_FLAG_FIELD_PREFIX + simpleFieldIndex / 32;
    }

    private int getCachedFlagIndex(JSimpleField jfield) {
        Preconditions.checkArgument((jfield.parent == this.jclass ? 1 : 0) != 0);
        int simpleFieldIndex = Ints.indexOf((int[])this.jclass.simpleFieldStorageIds, (int)jfield.storageId);
        Preconditions.checkArgument((simpleFieldIndex != -1 ? 1 : 0) != 0);
        return simpleFieldIndex;
    }

    static {
        try {
            JOBJECT_GET_OBJ_ID_METHOD = JObject.class.getMethod("getObjId", new Class[0]);
            JOBJECT_GET_TRANSACTION = JObject.class.getMethod("getTransaction", new Class[0]);
            JOBJECT_GET_MODEL_CLASS = JObject.class.getMethod("getModelClass", new Class[0]);
            JOBJECT_RESET_CACHED_FIELD_VALUES_METHOD = JObject.class.getMethod("resetCachedFieldValues", new Class[0]);
            JTRANSACTION_READ_COUNTER_FIELD_METHOD = JTransaction.class.getMethod("readCounterField", ObjId.class, Integer.TYPE, Boolean.TYPE);
            JTRANSACTION_READ_SET_FIELD_METHOD = JTransaction.class.getMethod("readSetField", ObjId.class, Integer.TYPE, Boolean.TYPE);
            JTRANSACTION_READ_LIST_FIELD_METHOD = JTransaction.class.getMethod("readListField", ObjId.class, Integer.TYPE, Boolean.TYPE);
            JTRANSACTION_READ_MAP_FIELD_METHOD = JTransaction.class.getMethod("readMapField", ObjId.class, Integer.TYPE, Boolean.TYPE);
            JTRANSACTION_GET_TRANSACTION_METHOD = JTransaction.class.getMethod("getTransaction", new Class[0]);
            JTRANSACTION_GET_METHOD = JTransaction.class.getMethod("get", ObjId.class);
            JTRANSACTION_REGISTER_JOBJECT_METHOD = JTransaction.class.getMethod("registerJObject", JObject.class);
            JTRANSACTION_GET_JSIMPLEDB_METHOD = JTransaction.class.getMethod("getJSimpleDB", new Class[0]);
            JTRANSACTION_FOLLOW_REFERENCE_PATH_METHOD = JTransaction.class.getMethod("followReferencePath", ReferencePath.class, Iterable.class);
            JTRANSACTION_INVERT_REFERENCE_PATH_METHOD = JTransaction.class.getMethod("invertReferencePath", ReferencePath.class, Iterable.class);
            JSIMPLEDB_PARSE_REFERENCE_PATH_METHOD = JSimpleDB.class.getMethod("parseReferencePath", Class.class, String.class, Boolean.TYPE);
            TRANSACTION_READ_SIMPLE_FIELD_METHOD = Transaction.class.getMethod("readSimpleField", ObjId.class, Integer.TYPE, Boolean.TYPE);
            TRANSACTION_WRITE_SIMPLE_FIELD_METHOD = Transaction.class.getMethod("writeSimpleField", ObjId.class, Integer.TYPE, Object.class, Boolean.TYPE);
            CONVERTER_CONVERT_METHOD = Converter.class.getMethod("convert", Object.class);
            CONVERTER_REVERSE_METHOD = Converter.class.getMethod("reverse", new Class[0]);
            ENUM_CONVERTER_CREATE_METHOD = EnumConverter.class.getMethod("createEnumConverter", Class.class);
            COLLECTIONS_SINGLETON_METHOD = Collections.class.getMethod("singleton", Object.class);
            OPTIONAL_OF_METHOD = Optional.class.getMethod("of", Object.class);
            OPTIONAL_EMPTY_METHOD = Optional.class.getMethod("empty", new Class[0]);
            SORTED_SET_FIRST_METHOD = SortedSet.class.getMethod("first", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("internal error", e);
        }
    }

    static interface CodeEmitter {
        public void emit(MethodVisitor var1);
    }
}

