/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import org.jsimpledb.CopyState;
import org.jsimpledb.JComplexField;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.SimpleFieldIndexInfo;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.type.ReferenceFieldType;

abstract class ComplexSubFieldIndexInfo
extends SimpleFieldIndexInfo {
    private final int parentStorageId;

    ComplexSubFieldIndexInfo(JSimpleField jfield) {
        super(jfield);
        assert (jfield.parent instanceof JComplexField);
        this.parentStorageId = jfield.getParentField().storageId;
    }

    public int getParentStorageId() {
        return this.parentStorageId;
    }

    public void copyRecurse(CopyState copyState, JTransaction srcTx, JTransaction dstTx, ObjId id, int fieldIndex, int[] fields) {
        assert (this.getFieldType() instanceof ReferenceFieldType);
        for (Object obj : this.iterateReferences(srcTx.tx, id)) {
            if (obj == null) continue;
            srcTx.copyTo(copyState, dstTx, (ObjId)obj, false, fieldIndex, fields);
        }
    }

    protected abstract Iterable<?> iterateReferences(Transaction var1, ObjId var2);

    @Override
    protected String toStringPrefix() {
        return super.toStringPrefix() + ",parentStorageId=" + this.getParentStorageId();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ComplexSubFieldIndexInfo that = (ComplexSubFieldIndexInfo)obj;
        return this.parentStorageId == that.parentStorageId;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.parentStorageId;
    }
}

