/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import java.util.ArrayList;
import java.util.List;
import org.jsimpledb.ConverterProvider;
import org.jsimpledb.IndexInfo;
import org.jsimpledb.JCompositeIndex;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.core.FieldType;

class CompositeIndexInfo
extends IndexInfo {
    private final List<Integer> storageIds;
    private final List<FieldType<?>> fieldTypes;
    private final List<Class<? extends Enum<?>>> enumTypes;
    private final List<ConverterProvider> converterProviders;

    CompositeIndexInfo(JCompositeIndex index) {
        super(index.storageId);
        this.storageIds = new ArrayList<Integer>(index.jfields.size());
        this.fieldTypes = new ArrayList(index.jfields.size());
        this.enumTypes = new ArrayList(index.jfields.size());
        this.converterProviders = new ArrayList<ConverterProvider>(index.jfields.size());
        for (JSimpleField jfield : index.jfields) {
            this.storageIds.add(jfield.storageId);
            this.fieldTypes.add(jfield.fieldType);
            this.converterProviders.add(ConverterProvider.identityForNull(jfield::getConverter));
        }
    }

    public List<Integer> getStorageIds() {
        return this.storageIds;
    }

    public List<FieldType<?>> getFieldTypes() {
        return this.fieldTypes;
    }

    public Converter<?, ?> getConverter(JTransaction jtx, int valueIndex) {
        return this.converterProviders.get(valueIndex).getConverter(jtx);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[storageId=" + this.getStorageId() + ",storageIds=" + this.getStorageIds() + ",fieldTypes=" + this.fieldTypes + ",enumTypes=" + this.enumTypes + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CompositeIndexInfo that = (CompositeIndexInfo)obj;
        return this.storageIds.equals(that.storageIds) && this.fieldTypes.equals(that.fieldTypes) && this.enumTypes.equals(that.enumTypes);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.storageIds.hashCode() ^ this.fieldTypes.hashCode() ^ this.enumTypes.hashCode();
    }
}

