/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.jsimpledb.DeletedAssignment;
import org.jsimpledb.JTransaction;
import org.jsimpledb.core.DeletedObjectException;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.ReferenceField;
import org.jsimpledb.core.util.ObjIdMap;
import org.jsimpledb.core.util.ObjIdSet;

@NotThreadSafe
public class CopyState
implements Cloneable {
    ObjIdMap<DeletedAssignment> deletedAssignments = new ObjIdMap();
    private final TreeMap<int[], ObjIdSet> traversedMap = new TreeMap(Ints.lexicographicalComparator());
    private ObjIdSet copied;
    private ObjIdMap<ObjId> objectIdMap;
    private boolean suppressNotifications;

    public CopyState() {
        this(new ObjIdSet(), null);
    }

    public CopyState(ObjIdMap<ObjId> objectIdMap) {
        this(new ObjIdSet(), objectIdMap);
    }

    public CopyState(ObjIdSet copied, ObjIdMap<ObjId> objectIdMap) {
        Preconditions.checkArgument((copied != null ? 1 : 0) != 0, (Object)"null copied");
        this.copied = copied;
        this.objectIdMap = objectIdMap;
    }

    public boolean markCopied(ObjId id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        return this.copied.add(id);
    }

    public boolean isCopied(ObjId id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        return this.copied.contains((Object)id);
    }

    public boolean isSuppressNotifications() {
        return this.suppressNotifications;
    }

    public void setSuppressNotifications(boolean suppressNotifications) {
        this.suppressNotifications = suppressNotifications;
    }

    public boolean markTraversed(ObjId id, int[] fields) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        Preconditions.checkArgument((fields != null ? 1 : 0) != 0, (Object)"null fields");
        Preconditions.checkArgument((fields.length > 0 ? 1 : 0) != 0, (Object)"empty fields");
        boolean fullPath = true;
        for (int limit = fields.length; limit > 0; --limit) {
            int[] prefix;
            int[] nArray = prefix = fullPath ? fields : Arrays.copyOfRange(fields, 0, limit);
            if (!this.traversedMap.computeIfAbsent(prefix, p -> new ObjIdSet()).add(id)) {
                return !fullPath;
            }
            fullPath = false;
        }
        return true;
    }

    public ObjIdMap<ObjId> getObjectIdMap() {
        return this.objectIdMap;
    }

    public ObjId getDestinationId(ObjId srcId) {
        Preconditions.checkArgument((srcId != null ? 1 : 0) != 0);
        if (this.objectIdMap == null) {
            return srcId;
        }
        ObjId dstId = (ObjId)this.objectIdMap.get((Object)srcId);
        return dstId != null ? dstId : srcId;
    }

    void checkDeletedAssignments(JTransaction jtx) {
        if (this.deletedAssignments.isEmpty()) {
            return;
        }
        Map.Entry entry = (Map.Entry)this.deletedAssignments.entrySet().iterator().next();
        DeletedAssignment deletedAssignment = (DeletedAssignment)entry.getValue();
        ObjId id = deletedAssignment.getId();
        ReferenceField field = deletedAssignment.getField();
        ObjId targetId = (ObjId)entry.getKey();
        throw new DeletedObjectException(targetId, "illegal assignment of deleted object " + targetId + " (" + jtx.tx.getTypeDescription(targetId) + ") to " + field + " in object " + id + " (" + jtx.tx.getTypeDescription(id) + ")");
    }

    public CopyState clone() {
        CopyState clone;
        try {
            clone = (CopyState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry<int[], ObjIdSet> entry : this.traversedMap.entrySet()) {
            clone.traversedMap.put(entry.getKey(), entry.getValue().clone());
        }
        clone.copied = this.copied.clone();
        clone.objectIdMap = this.objectIdMap.clone();
        clone.deletedAssignments = new ObjIdMap();
        return clone;
    }
}

