/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Transaction;

public class Counter {
    private final Transaction tx;
    private final ObjId id;
    private final int storageId;
    private final boolean updateVersion;

    Counter(Transaction tx, ObjId id, int storageId, boolean updateVersion) {
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        this.tx = tx;
        this.id = id;
        this.storageId = storageId;
        this.updateVersion = updateVersion;
    }

    public long get() {
        return this.tx.readCounterField(this.id, this.storageId, this.updateVersion);
    }

    public void set(long value) {
        this.tx.writeCounterField(this.id, this.storageId, value, this.updateVersion);
    }

    public void adjust(long offset) {
        this.tx.adjustCounterField(this.id, this.storageId, offset, this.updateVersion);
    }

    public void increment() {
        this.adjust(1L);
    }

    public void decrement() {
        this.adjust(-1L);
    }
}

