/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.NavigableSet;
import java.util.Optional;
import org.dellroad.stuff.java.MethodAnnotationScanner;
import org.jsimpledb.AnnotationScanner;
import org.jsimpledb.JClass;
import org.jsimpledb.ReferencePath;
import org.jsimpledb.Util;
import org.jsimpledb.annotation.FollowPath;
import org.jsimpledb.annotation.JSetField;

class FollowPathScanner<T>
extends AnnotationScanner<T, FollowPath> {
    FollowPathScanner(JClass<T> jclass) {
        super(jclass, FollowPath.class);
    }

    protected boolean includeMethod(Method method, FollowPath followPath) {
        this.checkNotStatic(method);
        this.checkParameterTypes(method, new TypeToken[0]);
        this.checkReturnType(method, followPath.firstOnly() ? Optional.class : NavigableSet.class);
        return true;
    }

    protected FollowPathMethodInfo createMethodInfo(Method method, FollowPath annotation) {
        return new FollowPathMethodInfo(method, annotation);
    }

    private static <E> TypeToken<NavigableSet<E>> buildNavigableSetType(Class<E> elementType) {
        return new TypeToken<NavigableSet<E>>(){}.where(new TypeParameter<E>(){}, elementType);
    }

    private static <E> TypeToken<Optional<E>> buildOptionalType(Class<E> elementType) {
        return new TypeToken<Optional<E>>(){}.where(new TypeParameter<E>(){}, elementType);
    }

    class FollowPathMethodInfo
    extends MethodAnnotationScanner.MethodInfo {
        private final ReferencePath path;
        private final boolean inverse;

        FollowPathMethodInfo(Method method, FollowPath followPath) {
            super((MethodAnnotationScanner)FollowPathScanner.this, method, (Annotation)followPath);
            if (Util.getAnnotation(method, JSetField.class) != null) {
                throw new IllegalArgumentException(FollowPathScanner.this.getErrorPrefix(method) + "method has conflicting annotations with both @" + JSetField.class.getSimpleName() + " and @" + FollowPath.class.getSimpleName());
            }
            Class modelType = FollowPathScanner.this.jclass.type;
            this.inverse = followPath.startingFrom() != Void.TYPE;
            try {
                if (!this.inverse && (followPath.value().equals("") || !followPath.inverseOf().equals("")) || this.inverse && (!followPath.value().equals("") || followPath.inverseOf().equals(""))) {
                    throw new IllegalArgumentException("invalid property combination: either value() or both startingFrom() and inverseOf() should be specified");
                }
                this.path = FollowPathScanner.this.jclass.jdb.parseReferencePath(this.inverse ? followPath.startingFrom() : modelType, this.inverse ? followPath.inverseOf() : followPath.value(), false);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(FollowPathScanner.this.getErrorPrefix(method) + "invalid reference path: " + e.getMessage(), e);
            }
            if (this.inverse) {
                TypeToken expectedType = followPath.firstOnly() ? FollowPathScanner.buildOptionalType(followPath.startingFrom()) : FollowPathScanner.buildNavigableSetType(followPath.startingFrom());
                FollowPathScanner.this.checkReturnType(method, Arrays.asList(expectedType));
                boolean matched = false;
                for (Class clazz : this.path.getTargetTypes()) {
                    if (!clazz.isAssignableFrom(modelType)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    throw new IllegalArgumentException(FollowPathScanner.this.getErrorPrefix(method) + "inverted reference path can never terminate in an instance of " + modelType);
                }
            } else {
                TypeToken returnType = TypeToken.of((Type)method.getGenericReturnType());
                TypeToken returnElementType = returnType.resolveType((followPath.firstOnly() ? Optional.class : NavigableSet.class).getTypeParameters()[0]);
                for (Class<?> clazz : this.path.getTargetTypes()) {
                    if (returnElementType.isSupertypeOf(clazz)) continue;
                    throw new IllegalArgumentException(FollowPathScanner.this.getErrorPrefix(method) + "return type element type " + returnElementType + " is not compatible with " + clazz);
                }
            }
        }

        public ReferencePath getReferencePath() {
            return this.path;
        }

        public boolean isInverse() {
            return this.inverse;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            FollowPathMethodInfo that = (FollowPathMethodInfo)((Object)obj);
            return this.path.equals(that.path) && this.inverse == that.inverse;
        }

        public int hashCode() {
            return super.hashCode() ^ this.path.hashCode() ^ Boolean.hashCode(this.inverse);
        }
    }
}

