/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.List;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.JCollectionField;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.ListConverter;
import org.jsimpledb.ListElementIndexInfo;
import org.jsimpledb.change.ListFieldAdd;
import org.jsimpledb.change.ListFieldClear;
import org.jsimpledb.change.ListFieldRemove;
import org.jsimpledb.change.ListFieldReplace;
import org.jsimpledb.schema.CollectionSchemaField;
import org.jsimpledb.schema.ListSchemaField;

public class JListField
extends JCollectionField {
    JListField(JSimpleDB jdb, String name, int storageId, JSimpleField elementField, String description, Method getter) {
        super(jdb, name, storageId, elementField, description, getter);
    }

    @Override
    public List<?> getValue(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        return jobj.getTransaction().readListField(jobj.getObjId(), this.storageId, false);
    }

    @Override
    public <R> R visit(JFieldSwitch<R> target) {
        return target.caseJListField(this);
    }

    ListSchemaField toSchemaItem(JSimpleDB jdb) {
        ListSchemaField schemaField = new ListSchemaField();
        super.initialize(jdb, (CollectionSchemaField)schemaField);
        return schemaField;
    }

    @Override
    ListElementIndexInfo toIndexInfo(JSimpleField subField) {
        assert (subField == this.elementField);
        return new ListElementIndexInfo(this);
    }

    <E> TypeToken<List<E>> buildTypeToken(TypeToken<E> elementType) {
        return new TypeToken<List<E>>(){}.where(new TypeParameter<E>(){}, elementType);
    }

    @Override
    <T, E> void addChangeParameterTypes(List<TypeToken<?>> types, Class<T> targetType, TypeToken<E> elementType) {
        types.add(new TypeToken<ListFieldAdd<T, E>>(){}.where(new TypeParameter<T>(){}, targetType).where(new TypeParameter<E>(){}, elementType.wrap()));
        types.add(new TypeToken<ListFieldClear<T>>(){}.where(new TypeParameter<T>(){}, targetType));
        types.add(new TypeToken<ListFieldRemove<T, E>>(){}.where(new TypeParameter<T>(){}, targetType).where(new TypeParameter<E>(){}, elementType.wrap()));
        types.add(new TypeToken<ListFieldReplace<T, E>>(){}.where(new TypeParameter<T>(){}, targetType).where(new TypeParameter<E>(){}, elementType.wrap()));
    }

    public ListConverter<?, ?> getConverter(JTransaction jtx) {
        Converter<?, ?> elementConverter = this.elementField.getConverter(jtx);
        return elementConverter != null ? this.createConverter(elementConverter) : null;
    }

    private <X, Y> ListConverter<X, Y> createConverter(Converter<X, Y> elementConverter) {
        return new ListConverter<X, Y>(elementConverter);
    }

    @Override
    Method getFieldReaderMethod() {
        return ClassGenerator.JTRANSACTION_READ_LIST_FIELD_METHOD;
    }
}

