/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import org.jsimpledb.AbstractFieldScanner;
import org.jsimpledb.JClass;
import org.jsimpledb.JFieldScanner;
import org.jsimpledb.annotation.JField;
import org.jsimpledb.annotation.JMapField;
import org.jsimpledb.annotation.JSimpleClass;

class JMapFieldScanner<T>
extends AbstractFieldScanner<T, JMapField> {
    JMapFieldScanner(JClass<T> jclass, JSimpleClass jsimpleClass) {
        super(jclass, JMapField.class, jsimpleClass);
    }

    @Override
    protected JMapField getDefaultAnnotation() {
        return new DefaultJMapField(this.jsimpleClass);
    }

    protected boolean includeMethod(Method method, JMapField annotation) {
        this.checkNotStatic(method);
        this.checkReturnType(method, Map.class, SortedMap.class, NavigableMap.class);
        this.checkParameterTypes(method, new TypeToken[0]);
        return true;
    }

    @Override
    protected boolean isAutoPropertyCandidate(Method method) {
        return super.isAutoPropertyCandidate(method) && Map.class.isAssignableFrom(method.getReturnType());
    }

    private static class DefaultJMapField
    implements JMapField {
        private JSimpleClass jsimpleClass;

        DefaultJMapField(JSimpleClass jsimpleClass) {
            this.jsimpleClass = jsimpleClass;
        }

        public Class<JMapField> annotationType() {
            return JMapField.class;
        }

        @Override
        public String name() {
            return "";
        }

        @Override
        public int storageId() {
            return 0;
        }

        @Override
        public JField key() {
            return JFieldScanner.getDefaultJField(this.jsimpleClass);
        }

        @Override
        public JField value() {
            return JFieldScanner.getDefaultJField(this.jsimpleClass);
        }
    }
}

