/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.JClass;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDBException;
import org.jsimpledb.JTransaction;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.util.ObjIdMap;

@ThreadSafe
class JObjectCache {
    private final JTransaction jtx;
    private final ReferenceQueue<JObject> referenceQueue = new ReferenceQueue();
    @GuardedBy(value="itself")
    private final ObjIdMap<JObjRef> cache = new ObjIdMap();
    private final ThreadLocal<ObjIdMap<JObject>> instantiations = new ThreadLocal();

    JObjectCache(JTransaction jtx) {
        this.jtx = jtx;
        assert (this.jtx != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JObject getIfExists(ObjId id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        ObjIdMap<JObjRef> objIdMap = this.cache;
        synchronized (objIdMap) {
            JObjRef ref = (JObjRef)this.cache.get((Object)id);
            if (ref != null) {
                return (JObject)ref.get();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JObject get(ObjId id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        boolean interrupted = false;
        ObjIdMap<JObjRef> objIdMap = this.cache;
        synchronized (objIdMap) {
            while (true) {
                this.gc();
                JObjRef ref = (JObjRef)this.cache.get((Object)id);
                if (ref != null) {
                    JObject jobj = (JObject)ref.get();
                    if (jobj == null) break;
                    return jobj;
                }
                if (!this.cache.containsKey((Object)id)) break;
                ObjIdMap<JObject> threadInstantiations = this.instantiations.get();
                if (threadInstantiations != null && threadInstantiations.containsKey((Object)id)) {
                    JObject jobj = (JObject)threadInstantiations.get((Object)id);
                    if (jobj != null) {
                        return jobj;
                    }
                    throw new RuntimeException("illegal reentrant query for object " + id + " during object construction");
                }
                try {
                    this.cache.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            this.cache.put(id, null);
        }
        JObject jobj = null;
        try {
            jobj = this.createJObject(id);
        }
        finally {
            ObjIdMap<JObjRef> objIdMap2 = this.cache;
            synchronized (objIdMap2) {
                assert (this.cache.containsKey((Object)id) && this.cache.get((Object)id) == null);
                this.gc();
                if (jobj != null) {
                    this.cache.put(id, (Object)new JObjRef(jobj, this.referenceQueue));
                } else {
                    this.cache.remove((Object)id);
                }
                this.cache.notifyAll();
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return jobj;
    }

    void register(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        Preconditions.checkArgument((jobj.getTransaction() == this.jtx ? 1 : 0) != 0, (Object)"wrong tx");
        ObjId id = jobj.getObjId();
        ObjIdMap<JObject> threadInstantiations = this.instantiations.get();
        if (threadInstantiations == null || !threadInstantiations.containsKey((Object)id)) {
            return;
        }
        JObject previous = (JObject)threadInstantiations.put(id, (Object)jobj);
        if (previous != null && previous != jobj) {
            threadInstantiations.put(id, (Object)previous);
            throw new IllegalArgumentException("conflicting JObject registration: " + jobj + " != " + previous);
        }
    }

    private JObject createJObject(ObjId id) {
        JObject registered;
        JObject jobj;
        JClass<?> jclass = this.jtx.jdb.jclasses.get(id.getStorageId());
        ClassGenerator<?> classGenerator = jclass != null ? jclass.getClassGenerator() : this.jtx.jdb.getUntypedClassGenerator();
        ObjIdMap threadInstantiations = this.instantiations.get();
        if (threadInstantiations == null) {
            threadInstantiations = new ObjIdMap(1);
            this.instantiations.set((ObjIdMap<JObject>)threadInstantiations);
        }
        threadInstantiations.put(id, null);
        try {
            jobj = (JObject)classGenerator.getConstructor().newInstance(this.jtx, id);
        }
        catch (Exception e) {
            Throwable cause = e;
            if (cause instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)cause).getTargetException();
            }
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new JSimpleDBException("can't instantiate object for ID " + id, cause);
        }
        finally {
            JObject registered2 = (JObject)threadInstantiations.remove((Object)id);
            if (threadInstantiations.isEmpty()) {
                this.instantiations.remove();
            }
        }
        if (registered != null && registered != jobj) {
            throw new IllegalArgumentException("conflicting JObject registration: " + jobj + " != " + registered);
        }
        assert (jobj != null);
        assert (jobj.getObjId().equals((Object)id));
        return jobj;
    }

    private void gc() {
        JObjRef ref;
        assert (Thread.holdsLock(this.cache));
        while ((ref = (JObjRef)this.referenceQueue.poll()) != null) {
            assert (ref.get() == null);
            ObjId id = ref.getObjId();
            if (this.cache.get((Object)id) != ref) continue;
            this.cache.remove((Object)id);
        }
    }

    private static class JObjRef
    extends WeakReference<JObject> {
        private final long id;

        JObjRef(JObject jobj, ReferenceQueue<JObject> queue) {
            super(jobj, queue);
            this.id = jobj.getObjId().asLong();
        }

        public ObjId getObjId() {
            return new ObjId(this.id);
        }
    }
}

