/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import org.jsimpledb.IndexInfo;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.schema.AbstractSchemaItem;

public abstract class JSchemaObject {
    final JSimpleDB jdb;
    final String name;
    final int storageId;
    final String description;

    JSchemaObject(JSimpleDB jdb, String name, int storageId, String description) {
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        Preconditions.checkArgument((storageId > 0 ? 1 : 0) != 0, (Object)"invalid non-positive storageId");
        Preconditions.checkArgument((description != null ? 1 : 0) != 0, (Object)"null description");
        this.jdb = jdb;
        this.name = name;
        this.storageId = storageId;
        this.description = description;
    }

    public JSimpleDB getJSimpleDB() {
        return this.jdb;
    }

    public String getName() {
        return this.name;
    }

    public int getStorageId() {
        return this.storageId;
    }

    IndexInfo toIndexInfo() {
        throw new UnsupportedOperationException();
    }

    abstract AbstractSchemaItem toSchemaItem(JSimpleDB var1);

    void initialize(JSimpleDB jdb, AbstractSchemaItem schemaItem) {
        schemaItem.setName(this.name);
        schemaItem.setStorageId(this.storageId);
    }

    public String toString() {
        return this.description;
    }
}

