/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.List;
import java.util.NavigableSet;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.JCollectionField;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.NavigableSetConverter;
import org.jsimpledb.SetElementIndexInfo;
import org.jsimpledb.change.SetFieldAdd;
import org.jsimpledb.change.SetFieldClear;
import org.jsimpledb.change.SetFieldRemove;
import org.jsimpledb.schema.CollectionSchemaField;
import org.jsimpledb.schema.SetSchemaField;

public class JSetField
extends JCollectionField {
    JSetField(JSimpleDB jdb, String name, int storageId, JSimpleField elementField, String description, Method getter) {
        super(jdb, name, storageId, elementField, description, getter);
    }

    @Override
    public NavigableSet<?> getValue(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        return jobj.getTransaction().readSetField(jobj.getObjId(), this.storageId, false);
    }

    @Override
    public <R> R visit(JFieldSwitch<R> target) {
        return target.caseJSetField(this);
    }

    SetSchemaField toSchemaItem(JSimpleDB jdb) {
        SetSchemaField schemaField = new SetSchemaField();
        super.initialize(jdb, (CollectionSchemaField)schemaField);
        return schemaField;
    }

    @Override
    SetElementIndexInfo toIndexInfo(JSimpleField subField) {
        assert (subField == this.elementField);
        return new SetElementIndexInfo(this);
    }

    <E> TypeToken<NavigableSet<E>> buildTypeToken(TypeToken<E> elementType) {
        return new TypeToken<NavigableSet<E>>(){}.where(new TypeParameter<E>(){}, elementType);
    }

    @Override
    <T, E> void addChangeParameterTypes(List<TypeToken<?>> types, Class<T> targetType, TypeToken<E> elementType) {
        types.add(new TypeToken<SetFieldAdd<T, E>>(){}.where(new TypeParameter<T>(){}, targetType).where(new TypeParameter<E>(){}, elementType.wrap()));
        types.add(new TypeToken<SetFieldClear<T>>(){}.where(new TypeParameter<T>(){}, targetType));
        types.add(new TypeToken<SetFieldRemove<T, E>>(){}.where(new TypeParameter<T>(){}, targetType).where(new TypeParameter<E>(){}, elementType.wrap()));
    }

    public NavigableSetConverter<?, ?> getConverter(JTransaction jtx) {
        Converter<?, ?> elementConverter = this.elementField.getConverter(jtx);
        return elementConverter != null ? this.createConverter(elementConverter) : null;
    }

    private <X, Y> NavigableSetConverter<X, Y> createConverter(Converter<X, Y> elementConverter) {
        return new NavigableSetConverter<X, Y>(elementConverter);
    }

    @Override
    Method getFieldReaderMethod() {
        return ClassGenerator.JTRANSACTION_READ_SET_FIELD_METHOD;
    }
}

