/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import org.jsimpledb.AbstractFieldScanner;
import org.jsimpledb.JClass;
import org.jsimpledb.JFieldScanner;
import org.jsimpledb.Util;
import org.jsimpledb.annotation.FollowPath;
import org.jsimpledb.annotation.JField;
import org.jsimpledb.annotation.JSetField;
import org.jsimpledb.annotation.JSimpleClass;

class JSetFieldScanner<T>
extends AbstractFieldScanner<T, JSetField> {
    JSetFieldScanner(JClass<T> jclass, JSimpleClass jsimpleClass) {
        super(jclass, JSetField.class, jsimpleClass);
    }

    @Override
    protected JSetField getDefaultAnnotation() {
        return new DefaultJSetField(this.jsimpleClass);
    }

    protected boolean includeMethod(Method method, JSetField annotation) {
        this.checkNotStatic(method);
        this.checkReturnType(method, Set.class, SortedSet.class, NavigableSet.class);
        this.checkParameterTypes(method, new TypeToken[0]);
        return true;
    }

    @Override
    protected boolean isAutoPropertyCandidate(Method method) {
        return super.isAutoPropertyCandidate(method) && Set.class.isAssignableFrom(method.getReturnType()) && Util.getAnnotation(method, FollowPath.class) == null;
    }

    private static class DefaultJSetField
    implements JSetField {
        private JSimpleClass jsimpleClass;

        DefaultJSetField(JSimpleClass jsimpleClass) {
            this.jsimpleClass = jsimpleClass;
        }

        public Class<JSetField> annotationType() {
            return JSetField.class;
        }

        @Override
        public String name() {
            return "";
        }

        @Override
        public int storageId() {
            return 0;
        }

        @Override
        public JField element() {
            return JFieldScanner.getDefaultJField(this.jsimpleClass);
        }
    }
}

