/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dellroad.stuff.java.Primitive;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.JComplexField;
import org.jsimpledb.JField;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JTransaction;
import org.jsimpledb.RegularSimpleFieldIndexInfo;
import org.jsimpledb.SimpleFieldIndexInfo;
import org.jsimpledb.UpgradeConversionPolicy;
import org.jsimpledb.asm.ClassWriter;
import org.jsimpledb.asm.Label;
import org.jsimpledb.asm.MethodVisitor;
import org.jsimpledb.asm.Type;
import org.jsimpledb.change.SimpleFieldChange;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.schema.AbstractSchemaItem;
import org.jsimpledb.schema.SimpleSchemaField;

public class JSimpleField
extends JField {
    final TypeToken<?> typeToken;
    final FieldType<?> fieldType;
    final boolean indexed;
    final boolean unique;
    final ArrayList<Object> uniqueExcludes;
    final UpgradeConversionPolicy upgradeConversion;
    final Method setter;

    JSimpleField(JSimpleDB jdb, String name, int storageId, TypeToken<?> typeToken, String typeName, boolean indexed, org.jsimpledb.annotation.JField annotation, String description, Method getter, Method setter) {
        this(jdb, name, storageId, typeToken, jdb.db.getFieldTypeRegistry().getFieldType(typeName), indexed, annotation, description, getter, setter);
    }

    JSimpleField(JSimpleDB jdb, String name, int storageId, TypeToken<?> typeToken, FieldType<?> fieldType, boolean indexed, org.jsimpledb.annotation.JField annotation, String description, Method getter, Method setter) {
        super(jdb, name, storageId, description, getter);
        Preconditions.checkArgument((typeToken != null ? 1 : 0) != 0, (Object)"null typeToken");
        Preconditions.checkArgument((fieldType != null ? 1 : 0) != 0, (Object)"null fieldType");
        Preconditions.checkArgument((annotation != null ? 1 : 0) != 0, (Object)"null annotation");
        this.typeToken = typeToken;
        this.fieldType = fieldType;
        this.indexed = indexed;
        this.unique = annotation.unique();
        this.setter = setter;
        this.upgradeConversion = annotation.upgradeConversion();
        int numExcludes = annotation.uniqueExclude().length;
        if (numExcludes > 0) {
            assert (this.unique);
            this.uniqueExcludes = new ArrayList(numExcludes);
            for (String string : annotation.uniqueExclude()) {
                if (string.equals("\u0000")) {
                    this.uniqueExcludes.add(null);
                    continue;
                }
                try {
                    this.uniqueExcludes.add(this.fieldType.fromString(string));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("invalid uniqueExclude() value `" + string + "': " + e.getMessage(), e);
                }
            }
            Collections.sort(this.uniqueExcludes, this.fieldType);
        } else {
            this.uniqueExcludes = null;
        }
    }

    public JComplexField getParentField() {
        return this.parent instanceof JComplexField ? (JComplexField)this.parent : null;
    }

    @Override
    public TypeToken<?> getTypeToken() {
        return this.typeToken;
    }

    public FieldType<?> getFieldType() {
        return this.fieldType;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public Method getSetter() {
        return this.setter;
    }

    @Override
    public Object getValue(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        Preconditions.checkArgument((!(this.parent instanceof JComplexField) ? 1 : 0) != 0, (Object)"field is a complex sub-field");
        return jobj.getTransaction().readSimpleField(jobj.getObjId(), this.storageId, false);
    }

    @Override
    public <R> R visit(JFieldSwitch<R> target) {
        return target.caseJSimpleField(this);
    }

    @Override
    public Converter<?, ?> getConverter(JTransaction jtx) {
        return null;
    }

    public void setValue(JObject jobj, Object value) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        Preconditions.checkArgument((!(this.parent instanceof JComplexField) ? 1 : 0) != 0, (Object)"field is a complex sub-field");
        jobj.getTransaction().writeSimpleField(jobj, this.storageId, value, false);
    }

    @Override
    boolean isSameAs(JField that0) {
        if (!super.isSameAs(that0)) {
            return false;
        }
        JSimpleField that = (JSimpleField)that0;
        if (!this.typeToken.equals(that.typeToken)) {
            return false;
        }
        if (!this.fieldType.equals(that.fieldType)) {
            return false;
        }
        if (this.indexed != that.indexed) {
            return false;
        }
        if (this.unique != that.unique) {
            return false;
        }
        if (!(this.uniqueExcludes == null ? that.uniqueExcludes == null : this.uniqueExcludes.equals(that.uniqueExcludes))) {
            return false;
        }
        return this.upgradeConversion.equals((Object)that.upgradeConversion);
    }

    SimpleSchemaField toSchemaItem(JSimpleDB jdb) {
        SimpleSchemaField schemaField = new SimpleSchemaField();
        this.initialize(jdb, schemaField);
        return schemaField;
    }

    @Override
    SimpleFieldIndexInfo toIndexInfo() {
        if (!this.indexed) {
            return null;
        }
        JComplexField parentField = this.getParentField();
        return parentField != null ? parentField.toIndexInfo(this) : new RegularSimpleFieldIndexInfo(this);
    }

    @Override
    void calculateRequiresDefaultValidation() {
        super.calculateRequiresDefaultValidation();
        this.requiresDefaultValidation |= this.unique;
    }

    void initialize(JSimpleDB jdb, SimpleSchemaField schemaField) {
        super.initialize(jdb, (AbstractSchemaItem)schemaField);
        schemaField.setType(this.fieldType.getName());
        schemaField.setIndexed(this.indexed);
    }

    @Override
    boolean supportsChangeNotifications() {
        return true;
    }

    @Override
    <T> void addChangeParameterTypes(List<TypeToken<?>> types, Class<T> targetType) {
        this.addChangeParameterTypes(types, targetType, this.typeToken);
    }

    private <T, V> void addChangeParameterTypes(List<TypeToken<?>> types, Class<T> targetType, TypeToken<V> fieldType) {
        types.add(new TypeToken<SimpleFieldChange<T, V>>(){}.where(new TypeParameter<T>(){}, targetType).where(new TypeParameter<V>(){}, fieldType.wrap()));
    }

    @Override
    void outputFields(ClassGenerator<?> generator, ClassWriter cw) {
        this.outputCachedValueField(generator, cw);
    }

    @Override
    void outputMethods(ClassGenerator<?> generator, ClassWriter cw) {
        Class<?> parameterType;
        String className = generator.getClassName();
        Class propertyType = this.typeToken.getRawType();
        boolean wide = propertyType.isPrimitive() && Primitive.get((Class)propertyType).getSize() == 8;
        MethodVisitor mv = cw.visitMethod(this.getter.getModifiers() & 5, this.getter.getName(), Type.getMethodDescriptor(this.getter), null, generator.getExceptionNames(this.getter));
        this.emitGetCachedFlag(generator, mv);
        Label notCached = new Label();
        mv.visitJumpInsn(153, notCached);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, this.getCachedValueFieldName(), Type.getDescriptor(propertyType));
        mv.visitInsn(Type.getType(propertyType).getOpcode(172));
        mv.visitLabel(notCached);
        mv.visitFrame(3, 0, new Object[0], 0, new Object[0]);
        mv.visitVarInsn(25, 0);
        this.outputReadCoreValueBytecode(generator, mv);
        mv.visitTypeInsn(192, Type.getInternalName(this.typeToken.wrap().getRawType()));
        if (propertyType.isPrimitive()) {
            generator.unwrap(mv, Primitive.get((Class)propertyType));
        }
        mv.visitInsn(wide ? 93 : 90);
        mv.visitFieldInsn(181, className, this.getCachedValueFieldName(), Type.getDescriptor(propertyType));
        this.emitSetCachedFlag(generator, mv, true);
        mv.visitInsn(Type.getType(propertyType).getOpcode(172));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(this.setter.getModifiers() & 5, this.setter.getName(), Type.getMethodDescriptor(this.setter), null, generator.getExceptionNames(this.setter));
        this.emitSetCachedFlag(generator, mv, false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(Type.getType(propertyType).getOpcode(21), 1);
        if (!this.typeToken.isPrimitive() && !propertyType.isAssignableFrom(parameterType = this.setter.getParameterTypes()[0])) {
            mv.visitTypeInsn(192, Type.getInternalName(propertyType));
        }
        mv.visitInsn(wide ? 92 : 89);
        if (this.typeToken.isPrimitive()) {
            generator.wrap(mv, Primitive.get((Class)propertyType));
        }
        this.outputWriteCoreValueBytecode(generator, mv);
        mv.visitFieldInsn(181, className, this.getCachedValueFieldName(), Type.getDescriptor(propertyType));
        this.emitSetCachedFlag(generator, mv, true);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void emitGetCachedFlag(ClassGenerator<?> generator, MethodVisitor mv) {
        String className = generator.getClassName();
        String fieldName = generator.getCachedFlagFieldName(this);
        int flagBit = generator.getCachedFlagBit(this);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, fieldName, Type.getDescriptor(generator.getCachedFlagFieldType(this)));
        switch (flagBit) {
            case 1: {
                mv.visitInsn(4);
                break;
            }
            case 2: {
                mv.visitInsn(5);
                break;
            }
            case 4: {
                mv.visitInsn(7);
                break;
            }
            default: {
                mv.visitLdcInsn(flagBit);
            }
        }
        mv.visitInsn(126);
    }

    private void emitSetCachedFlag(ClassGenerator<?> generator, MethodVisitor mv, boolean set) {
        String className = generator.getClassName();
        String fieldName = generator.getCachedFlagFieldName(this);
        int flagBit = generator.getCachedFlagBit(this);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, className, fieldName, Type.getDescriptor(generator.getCachedFlagFieldType(this)));
        if (set) {
            switch (flagBit) {
                case 1: {
                    mv.visitInsn(4);
                    break;
                }
                case 2: {
                    mv.visitInsn(5);
                    break;
                }
                case 4: {
                    mv.visitInsn(7);
                    break;
                }
                default: {
                    mv.visitLdcInsn(flagBit);
                }
            }
            mv.visitInsn(128);
        } else {
            mv.visitLdcInsn(~flagBit);
            mv.visitInsn(126);
        }
        mv.visitFieldInsn(181, className, fieldName, Type.getDescriptor(generator.getCachedFlagFieldType(this)));
    }

    void outputReadCoreValueBytecode(ClassGenerator<?> generator, MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, generator.getClassName(), "$tx", Type.getDescriptor(JTransaction.class));
        generator.emitInvoke(mv, ClassGenerator.JTRANSACTION_GET_TRANSACTION_METHOD);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, generator.getClassName(), "$id", Type.getDescriptor(ObjId.class));
        mv.visitLdcInsn(this.storageId);
        mv.visitInsn(4);
        generator.emitInvoke(mv, ClassGenerator.TRANSACTION_READ_SIMPLE_FIELD_METHOD);
    }

    void outputWriteCoreValueBytecode(ClassGenerator<?> generator, MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        generator.emitInvoke(mv, ClassGenerator.JTRANSACTION_REGISTER_JOBJECT_METHOD);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, generator.getClassName(), "$tx", Type.getDescriptor(JTransaction.class));
        generator.emitInvoke(mv, ClassGenerator.JTRANSACTION_GET_TRANSACTION_METHOD);
        mv.visitInsn(95);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, generator.getClassName(), "$id", Type.getDescriptor(ObjId.class));
        mv.visitInsn(95);
        mv.visitLdcInsn(this.storageId);
        mv.visitInsn(95);
        mv.visitInsn(4);
        generator.emitInvoke(mv, ClassGenerator.TRANSACTION_WRITE_SIMPLE_FIELD_METHOD);
    }
}

