/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.reflect.TypeToken;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NavigableSet;
import org.dellroad.stuff.java.MethodAnnotationScanner;
import org.jsimpledb.AllChangesListener;
import org.jsimpledb.AnnotationScanner;
import org.jsimpledb.JClass;
import org.jsimpledb.JField;
import org.jsimpledb.JListField;
import org.jsimpledb.JMapField;
import org.jsimpledb.JObject;
import org.jsimpledb.JSetField;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.ReferencePath;
import org.jsimpledb.Util;
import org.jsimpledb.annotation.OnChange;
import org.jsimpledb.change.FieldChange;
import org.jsimpledb.change.ListFieldAdd;
import org.jsimpledb.change.ListFieldClear;
import org.jsimpledb.change.ListFieldRemove;
import org.jsimpledb.change.ListFieldReplace;
import org.jsimpledb.change.MapFieldAdd;
import org.jsimpledb.change.MapFieldClear;
import org.jsimpledb.change.MapFieldRemove;
import org.jsimpledb.change.MapFieldReplace;
import org.jsimpledb.change.SetFieldAdd;
import org.jsimpledb.change.SetFieldClear;
import org.jsimpledb.change.SetFieldRemove;
import org.jsimpledb.change.SimpleFieldChange;
import org.jsimpledb.core.Field;
import org.jsimpledb.core.ListField;
import org.jsimpledb.core.MapField;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.SetField;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.TypeNotInSchemaVersionException;
import org.jsimpledb.core.UnknownFieldException;

class OnChangeScanner<T>
extends AnnotationScanner<T, OnChange> {
    OnChangeScanner(JClass<T> jclass) {
        super(jclass, OnChange.class);
    }

    protected boolean includeMethod(Method method, OnChange annotation) {
        this.checkReturnType(method, Void.TYPE);
        if (this.getParameterTypeTokens(method).size() > 1) {
            throw new IllegalArgumentException(this.getErrorPrefix(method) + "method is required to take zero or one parameter");
        }
        return true;
    }

    protected ChangeMethodInfo createMethodInfo(Method method, OnChange annotation) {
        return new ChangeMethodInfo(method, annotation);
    }

    class ChangeMethodInfo
    extends MethodAnnotationScanner.MethodInfo
    implements AllChangesListener {
        final HashSet<ReferencePath> paths;
        final Class<?>[] genericTypes;

        ChangeMethodInfo(Method method, OnChange annotation) {
            TypeToken<?> genericParameterType;
            Class<?> rawParameterType;
            ArrayList<String> unexpandedPathList;
            super((MethodAnnotationScanner)OnChangeScanner.this, method, (Annotation)annotation);
            JSimpleDB jdb = OnChangeScanner.this.jclass.jdb;
            Class<?> startType = method.getDeclaringClass();
            if (annotation.startType() != Void.TYPE) {
                if ((method.getModifiers() & 8) == 0) {
                    throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + "startType() may only be used for annotations on static methods");
                }
                if (annotation.startType().isPrimitive() || annotation.startType().isArray()) {
                    throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + "invalid startType() " + annotation.startType());
                }
                startType = annotation.startType();
            }
            if ((unexpandedPathList = new ArrayList<String>(Arrays.asList(annotation.value()))).isEmpty()) {
                unexpandedPathList.add("*");
            }
            ArrayList<String> expandedPathList = new ArrayList<String>(unexpandedPathList.size());
            HashSet<Integer> expandedPathWasWildcard = new HashSet<Integer>();
            for (String unexpandedPath : unexpandedPathList) {
                if (unexpandedPath.equals("*")) {
                    for (JClass<?> jclass : jdb.getJClasses(startType)) {
                        for (JField jField : jclass.jfields.values()) {
                            expandedPathWasWildcard.add(expandedPathList.size());
                            expandedPathList.add(jField.name + "#" + jField.storageId);
                        }
                    }
                    continue;
                }
                if (unexpandedPath.length() > 2 && unexpandedPath.endsWith(".*")) {
                    ReferencePath prefixReferencePath;
                    String prefixPath = unexpandedPath.substring(0, unexpandedPath.length() - 2);
                    try {
                        prefixReferencePath = jdb.parseReferencePath(startType, prefixPath, false, true);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + illegalArgumentException.getMessage(), illegalArgumentException);
                    }
                    HashSet hashSet = new HashSet(prefixReferencePath.cursors.size() * 2);
                    for (ReferencePath.Cursor cursor : prefixReferencePath.cursors) {
                        for (JField jfield : cursor.getJClass().jfields.values()) {
                            if (!jfield.supportsChangeNotifications()) continue;
                            expandedPathWasWildcard.add(expandedPathList.size());
                            expandedPathList.add(prefixPath + "." + jfield.name + "#" + jfield.storageId);
                        }
                    }
                    continue;
                }
                expandedPathList.add(unexpandedPath);
            }
            switch (method.getParameterTypes().length) {
                case 1: {
                    rawParameterType = method.getParameterTypes()[0];
                    genericParameterType = OnChangeScanner.this.getParameterTypeTokens(method).get(0);
                    Type firstParameterType = method.getGenericParameterTypes()[0];
                    if (firstParameterType instanceof ParameterizedType) {
                        ArrayList<Class> genericTypeList = new ArrayList<Class>(3);
                        for (Type type : ((ParameterizedType)firstParameterType).getActualTypeArguments()) {
                            genericTypeList.add(TypeToken.of((Type)type).getRawType());
                        }
                        this.genericTypes = genericTypeList.toArray(new Class[genericTypeList.size()]);
                        break;
                    }
                    this.genericTypes = new Class[]{rawParameterType};
                    break;
                }
                case 0: {
                    rawParameterType = null;
                    genericParameterType = null;
                    this.genericTypes = null;
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
            boolean anyFieldsFound = false;
            this.paths = new HashSet(expandedPathList.size());
            for (int i = 0; i < expandedPathList.size(); ++i) {
                ReferencePath path;
                String string = (String)expandedPathList.get(i);
                boolean bl = expandedPathWasWildcard.contains(i);
                try {
                    path = jdb.parseReferencePath(startType, string, true, false);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + e.getMessage(), e);
                }
                if (rawParameterType != null) {
                    ArrayList possibleChangeTypes = new ArrayList();
                    for (ReferencePath.Cursor cursor : path.cursors) {
                        try {
                            cursor.getField().addChangeParameterTypes(possibleChangeTypes, cursor.getJClass().getType());
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            if (bl) continue;
                        }
                        anyFieldsFound = true;
                    }
                    if (possibleChangeTypes.isEmpty() && !bl) {
                        throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + "path `" + string + "' is invalid because change notifications are not supported for any target field");
                    }
                    boolean anyChangeMatch = false;
                    for (TypeToken typeToken : possibleChangeTypes) {
                        boolean matchesGeneric = genericParameterType.isSupertypeOf(typeToken);
                        boolean matchesRaw = rawParameterType.isAssignableFrom(typeToken.getRawType());
                        assert (!matchesGeneric || matchesRaw);
                        if (matchesGeneric != matchesRaw) {
                            throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + "parameter type " + genericParameterType + " will match change events of type " + typeToken + " from field `" + string + "' at runtime due to type erasure, but its generic type is does not match " + typeToken + "; try narrowing or widening the parameter type, keeping it compatible with " + (possibleChangeTypes.size() != 1 ? "one or more of: " + possibleChangeTypes : (Serializable)possibleChangeTypes.get(0)));
                        }
                        if (!matchesGeneric) continue;
                        anyChangeMatch = true;
                        break;
                    }
                    if (!anyChangeMatch) {
                        if (bl) continue;
                        throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + "path `" + string + "' is invalid because no changes emitted by the target field match the method's parameter type " + genericParameterType + "; the emitted change type is " + (possibleChangeTypes.size() != 1 ? "one of: " + possibleChangeTypes : (Serializable)possibleChangeTypes.get(0)));
                    }
                }
                this.paths.add(path);
            }
            if (this.paths.isEmpty()) {
                if (!anyFieldsFound) {
                    throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + "there are no fields that will generate change events");
                }
                throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + "no changes emitted by any field will match the method's parameter type " + genericParameterType);
            }
        }

        void registerChangeListener(Transaction tx) {
            for (ReferencePath path : this.paths) {
                tx.addFieldChangeListener(path.targetFieldStorageId, path.getReferenceFields(), path.getPathKeyRanges(), (Object)this);
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            ChangeMethodInfo that = (ChangeMethodInfo)obj;
            return this.paths.equals(that.paths);
        }

        public int hashCode() {
            return super.hashCode() ^ this.paths.hashCode();
        }

        public <T> void onSimpleFieldChange(Transaction tx, ObjId id, SimpleField<T> field, int[] path, NavigableSet<ObjId> referrers, T oldValue, T newValue) {
            Object jnewValue;
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            JSimpleField jfield = this.getJField(jtx, id, (Field<?>)field, (Class<T>)JSimpleField.class);
            if (jfield == null) {
                return;
            }
            if (this.genericTypes == null) {
                this.invoke(jtx, referrers);
                return;
            }
            Object joldValue = this.convertCoreValue(jtx, jfield, oldValue);
            JObject jobj = this.checkTypes(jtx, SimpleFieldChange.class, id, joldValue, jnewValue = this.convertCoreValue(jtx, jfield, newValue));
            if (jobj == null) {
                return;
            }
            this.invoke(jtx, referrers, new SimpleFieldChange<JObject, Object>(jobj, field.getStorageId(), field.getName(), joldValue, jnewValue));
        }

        public <E> void onSetFieldAdd(Transaction tx, ObjId id, SetField<E> field, int[] path, NavigableSet<ObjId> referrers, E value) {
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            JSetField jfield = this.getJField(jtx, id, (Field<?>)field, (Class)JSetField.class);
            if (jfield == null) {
                return;
            }
            if (this.genericTypes == null) {
                this.invoke(jtx, referrers);
                return;
            }
            Object jvalue = this.convertCoreValue(jtx, jfield.elementField, value);
            JObject jobj = this.checkTypes(jtx, SetFieldAdd.class, id, jvalue);
            if (jobj == null) {
                return;
            }
            this.invoke(jtx, referrers, new SetFieldAdd<JObject, Object>(jobj, jfield.storageId, jfield.name, jvalue));
        }

        public <E> void onSetFieldRemove(Transaction tx, ObjId id, SetField<E> field, int[] path, NavigableSet<ObjId> referrers, E value) {
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            JSetField jfield = this.getJField(jtx, id, (Field<?>)field, (Class)JSetField.class);
            if (jfield == null) {
                return;
            }
            if (this.genericTypes == null) {
                this.invoke(jtx, referrers);
                return;
            }
            Object jvalue = this.convertCoreValue(jtx, jfield.elementField, value);
            JObject jobj = this.checkTypes(jtx, SetFieldRemove.class, id, jvalue);
            if (jobj == null) {
                return;
            }
            this.invoke(jtx, referrers, new SetFieldRemove<JObject, Object>(jobj, jfield.storageId, jfield.name, jvalue));
        }

        public void onSetFieldClear(Transaction tx, ObjId id, SetField<?> field, int[] path, NavigableSet<ObjId> referrers) {
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            JSetField jfield = this.getJField(jtx, id, (Field<?>)field, (Class)JSetField.class);
            if (jfield == null) {
                return;
            }
            if (this.genericTypes == null) {
                this.invoke(jtx, referrers);
                return;
            }
            JObject jobj = this.checkTypes(jtx, SetFieldClear.class, id, new Object[0]);
            if (jobj == null) {
                return;
            }
            this.invoke(jtx, referrers, new SetFieldClear<JObject>(jobj, jfield.storageId, jfield.name));
        }

        public <E> void onListFieldAdd(Transaction tx, ObjId id, ListField<E> field, int[] path, NavigableSet<ObjId> referrers, int index, E value) {
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            JListField jfield = this.getJField(jtx, id, (Field<?>)field, (Class)JListField.class);
            if (jfield == null) {
                return;
            }
            if (this.genericTypes == null) {
                this.invoke(jtx, referrers);
                return;
            }
            Object jvalue = this.convertCoreValue(jtx, jfield.elementField, value);
            JObject jobj = this.checkTypes(jtx, ListFieldAdd.class, id, jvalue);
            if (jobj == null) {
                return;
            }
            this.invoke(jtx, referrers, new ListFieldAdd<JObject, Object>(jobj, jfield.storageId, jfield.name, index, jvalue));
        }

        public <E> void onListFieldRemove(Transaction tx, ObjId id, ListField<E> field, int[] path, NavigableSet<ObjId> referrers, int index, E value) {
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            JListField jfield = this.getJField(jtx, id, (Field<?>)field, (Class)JListField.class);
            if (jfield == null) {
                return;
            }
            if (this.genericTypes == null) {
                this.invoke(jtx, referrers);
                return;
            }
            Object jvalue = this.convertCoreValue(jtx, jfield.elementField, value);
            JObject jobj = this.checkTypes(jtx, ListFieldRemove.class, id, jvalue);
            if (jobj == null) {
                return;
            }
            this.invoke(jtx, referrers, new ListFieldRemove<JObject, Object>(jobj, jfield.storageId, jfield.name, index, jvalue));
        }

        public <E> void onListFieldReplace(Transaction tx, ObjId id, ListField<E> field, int[] path, NavigableSet<ObjId> referrers, int index, E oldValue, E newValue) {
            Object jnewValue;
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            JListField jfield = this.getJField(jtx, id, (Field<?>)field, (Class)JListField.class);
            if (jfield == null) {
                return;
            }
            if (this.genericTypes == null) {
                this.invoke(jtx, referrers);
                return;
            }
            Object joldValue = this.convertCoreValue(jtx, jfield.elementField, oldValue);
            JObject jobj = this.checkTypes(jtx, ListFieldReplace.class, id, joldValue, jnewValue = this.convertCoreValue(jtx, jfield.elementField, newValue));
            if (jobj == null) {
                return;
            }
            this.invoke(jtx, referrers, new ListFieldReplace<JObject, Object>(jobj, jfield.storageId, jfield.name, index, joldValue, jnewValue));
        }

        public void onListFieldClear(Transaction tx, ObjId id, ListField<?> field, int[] path, NavigableSet<ObjId> referrers) {
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            JListField jfield = this.getJField(jtx, id, (Field<?>)field, (Class)JListField.class);
            if (jfield == null) {
                return;
            }
            if (this.genericTypes == null) {
                this.invoke(jtx, referrers);
                return;
            }
            JObject jobj = this.checkTypes(jtx, ListFieldClear.class, id, new Object[0]);
            if (jobj == null) {
                return;
            }
            this.invoke(jtx, referrers, new ListFieldClear<JObject>(jobj, jfield.storageId, jfield.name));
        }

        public <K, V> void onMapFieldAdd(Transaction tx, ObjId id, MapField<K, V> field, int[] path, NavigableSet<ObjId> referrers, K key, V value) {
            Object jvalue;
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            JMapField jfield = this.getJField(jtx, id, (Field<?>)field, (Class)JMapField.class);
            if (jfield == null) {
                return;
            }
            if (this.genericTypes == null) {
                this.invoke(jtx, referrers);
                return;
            }
            Object jkey = this.convertCoreValue(jtx, jfield.keyField, key);
            JObject jobj = this.checkTypes(jtx, MapFieldAdd.class, id, jkey, jvalue = this.convertCoreValue(jtx, jfield.valueField, value));
            if (jobj == null) {
                return;
            }
            this.invoke(jtx, referrers, new MapFieldAdd<JObject, Object, Object>(jobj, jfield.storageId, jfield.name, jkey, jvalue));
        }

        public <K, V> void onMapFieldRemove(Transaction tx, ObjId id, MapField<K, V> field, int[] path, NavigableSet<ObjId> referrers, K key, V value) {
            Object jvalue;
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            JMapField jfield = this.getJField(jtx, id, (Field<?>)field, (Class)JMapField.class);
            if (jfield == null) {
                return;
            }
            if (this.genericTypes == null) {
                this.invoke(jtx, referrers);
                return;
            }
            Object jkey = this.convertCoreValue(jtx, jfield.keyField, key);
            JObject jobj = this.checkTypes(jtx, MapFieldRemove.class, id, jkey, jvalue = this.convertCoreValue(jtx, jfield.valueField, value));
            if (jobj == null) {
                return;
            }
            this.invoke(jtx, referrers, new MapFieldRemove<JObject, Object, Object>(jobj, jfield.storageId, jfield.name, jkey, jvalue));
        }

        public <K, V> void onMapFieldReplace(Transaction tx, ObjId id, MapField<K, V> field, int[] path, NavigableSet<ObjId> referrers, K key, V oldValue, V newValue) {
            Object jnewValue;
            Object joldValue;
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            JMapField jfield = this.getJField(jtx, id, (Field<?>)field, (Class)JMapField.class);
            if (jfield == null) {
                return;
            }
            if (this.genericTypes == null) {
                this.invoke(jtx, referrers);
                return;
            }
            Object jkey = this.convertCoreValue(jtx, jfield.keyField, key);
            JObject jobj = this.checkTypes(jtx, MapFieldReplace.class, id, jkey, joldValue = this.convertCoreValue(jtx, jfield.valueField, oldValue), jnewValue = this.convertCoreValue(jtx, jfield.valueField, newValue));
            if (jobj == null) {
                return;
            }
            this.invoke(jtx, referrers, new MapFieldReplace<JObject, Object, Object>(jobj, jfield.storageId, jfield.name, jkey, joldValue, jnewValue));
        }

        public void onMapFieldClear(Transaction tx, ObjId id, MapField<?, ?> field, int[] path, NavigableSet<ObjId> referrers) {
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            JMapField jfield = this.getJField(jtx, id, (Field<?>)field, (Class)JMapField.class);
            if (jfield == null) {
                return;
            }
            if (this.genericTypes == null) {
                this.invoke(jtx, referrers);
                return;
            }
            JObject jobj = this.checkTypes(jtx, MapFieldClear.class, id, new Object[0]);
            if (jobj == null) {
                return;
            }
            this.invoke(jtx, referrers, new MapFieldClear<JObject>(jobj, jfield.storageId, jfield.name));
        }

        private <T extends JField> T getJField(JTransaction jtx, ObjId id, Field<?> field, Class<T> type) {
            try {
                return jtx.jdb.getJField(id, field.getStorageId(), type);
            }
            catch (TypeNotInSchemaVersionException | UnknownFieldException e) {
                return null;
            }
        }

        private Object convertCoreValue(JTransaction jtx, JSimpleField jfield, Object value) {
            Converter<?, ?> converter = jfield.getConverter(jtx);
            return converter != null ? converter.convert(value) : value;
        }

        private JObject checkTypes(JTransaction jtx, Class<?> changeType, ObjId id, Object ... values) {
            Method method = this.getMethod();
            if (!method.getParameterTypes()[0].isAssignableFrom(changeType)) {
                return null;
            }
            JObject jobj = jtx.get(id);
            if (!this.genericTypes[0].isInstance(jobj)) {
                return null;
            }
            for (int i = 1; i < this.genericTypes.length; ++i) {
                Object value = values[Math.min(i, values.length) - 1];
                if (value == null || this.genericTypes[i].isInstance(value)) continue;
                return null;
            }
            return jobj;
        }

        private void invoke(JTransaction jtx, NavigableSet<ObjId> referrers) {
            Method method = this.getMethod();
            if ((method.getModifiers() & 8) != 0) {
                Util.invoke(method, null, new Object[0]);
            } else {
                for (ObjId id : referrers) {
                    JObject target = jtx.get(id);
                    if (!method.getDeclaringClass().isInstance(target)) continue;
                    Util.invoke(method, target, new Object[0]);
                }
            }
        }

        private void invoke(JTransaction jtx, NavigableSet<ObjId> referrers, FieldChange<JObject> change) {
            assert (change != null);
            Method method = this.getMethod();
            if ((method.getModifiers() & 8) != 0) {
                Util.invoke(method, null, change);
            } else {
                for (ObjId id : referrers) {
                    JObject target = jtx.get(id);
                    if (!method.getDeclaringClass().isInstance(target)) continue;
                    Util.invoke(method, target, change);
                }
            }
        }
    }
}

