/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import org.jsimpledb.JObject;
import org.jsimpledb.JTransaction;
import org.jsimpledb.core.ObjId;

class ReferenceConverter<T>
extends Converter<T, ObjId> {
    private final JTransaction jtx;
    private final Class<T> type;

    ReferenceConverter(JTransaction jtx, Class<T> type) {
        assert (jtx != null);
        assert (type != null);
        this.jtx = jtx;
        this.type = type;
    }

    protected ObjId doForward(T jobj) {
        if (jobj == null) {
            return null;
        }
        return ((JObject)jobj).getObjId();
    }

    protected T doBackward(ObjId id) {
        if (id == null) {
            return null;
        }
        JObject jobj = this.jtx.get(id);
        return this.type.cast(jobj);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ReferenceConverter that = (ReferenceConverter)((Object)obj);
        return this.jtx == that.jtx;
    }

    public int hashCode() {
        return this.jtx.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[type=" + this.type + ",jtx=" + this.jtx + "]";
    }
}

