/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.Constraint;
import javax.validation.groups.Default;
import org.jsimpledb.JSimpleDBException;
import org.jsimpledb.MethodKey;
import org.jsimpledb.annotation.OnValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final String ANNOTATION_ELEMENT_UTILS_CLASS_NAME = "org.springframework.core.annotation.AnnotatedElementUtils";
    private static final String ANNOTATION_ELEMENT_UTILS_GET_MERGED_ANNOTATION_METHOD_NAME = "getMergedAnnotation";
    private static final WildcardType QUESTION_MARK = new WildcardType(){

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{Object.class};
        }

        @Override
        public Type[] getLowerBounds() {
            return new Type[0];
        }

        public String toString() {
            return "?";
        }
    };
    private static Method newParameterizedTypeMethod;
    private static BiFunction<AnnotatedElement, Class<? extends Annotation>, Annotation> annotationRetriever;

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends Annotation> A getAnnotation(AnnotatedElement element, Class<A> annotationType) {
        Preconditions.checkArgument((element != null ? 1 : 0) != 0, (Object)"null element");
        Preconditions.checkArgument((annotationType != null ? 1 : 0) != 0, (Object)"null annotationType");
        Class<Util> clazz = Util.class;
        synchronized (Util.class) {
            if (annotationRetriever == null) {
                Logger log = LoggerFactory.getLogger(Util.class);
                try {
                    Class<?> cl = Class.forName(ANNOTATION_ELEMENT_UTILS_CLASS_NAME, true, Thread.currentThread().getContextClassLoader());
                    Method method = cl.getMethod(ANNOTATION_ELEMENT_UTILS_GET_MERGED_ANNOTATION_METHOD_NAME, AnnotatedElement.class, Class.class);
                    annotationRetriever = (elem, atype) -> {
                        try {
                            return (Annotation)atype.cast(method.invoke(null, elem, atype));
                        }
                        catch (Exception e) {
                            throw new RuntimeException("internal error", e);
                        }
                    };
                    if (log.isDebugEnabled()) {
                        log.debug("using Spring's " + cl.getSimpleName() + "." + method.getName() + "() for annotation retrieval");
                    }
                }
                catch (ClassNotFoundException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("using JDK AnnotatedElement.getAnnotation() for annotation retrieval");
                    }
                    annotationRetriever = (elem, atype) -> elem.getAnnotation(atype);
                }
                catch (Exception e) {
                    log.warn("using JDK AnnotatedElement.getAnnotation() for annotation retrieval", (Throwable)e);
                    annotationRetriever = (elem, atype) -> elem.getAnnotation(atype);
                }
            }
            assert (annotationRetriever != null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (A)((Annotation)annotationType.cast(annotationRetriever.apply(element, annotationType)));
        }
    }

    public static AnnotatedElement hasValidation(Class<?> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        if (Util.hasValidationAnnotation(type)) {
            return type;
        }
        for (Method method : type.getDeclaredMethods()) {
            if ((method.getModifiers() & 1) == 0 || !Util.hasValidationAnnotation(method)) continue;
            return method;
        }
        for (TypeToken typeToken : TypeToken.of(type).getTypes()) {
            AnnotatedElement annotatedElement;
            Class superType = typeToken.getRawType();
            if (superType == type || (annotatedElement = Util.hasValidation(superType)) == null) continue;
            return annotatedElement;
        }
        return null;
    }

    public static boolean requiresDefaultValidation(Class<?> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        if (Util.hasDefaultValidationAnnotation(type)) {
            return true;
        }
        for (Method method : type.getDeclaredMethods()) {
            if (method.isAnnotationPresent(OnValidate.class)) {
                return true;
            }
            if ((method.getModifiers() & 1) == 0 || !Util.requiresDefaultValidation(method)) continue;
            return true;
        }
        for (TypeToken typeToken : TypeToken.of(type).getTypes()) {
            Class superType = typeToken.getRawType();
            if (superType == type || !Util.requiresDefaultValidation(superType)) continue;
            return true;
        }
        return false;
    }

    public static boolean requiresDefaultValidation(Method method) {
        Preconditions.checkArgument((method != null ? 1 : 0) != 0, (Object)"null method");
        String methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        for (TypeToken typeToken : TypeToken.of(method.getDeclaringClass()).getTypes()) {
            Class superType = typeToken.getRawType();
            try {
                method = superType.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            if (!Util.hasDefaultValidationAnnotation(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDefaultValidationAnnotation(AnnotatedElement obj) {
        return Util.hasValidationAnnotation(obj, new Class[]{Default.class});
    }

    public static boolean hasValidationAnnotation(AnnotatedElement obj) {
        return Util.hasValidationAnnotation(obj, null);
    }

    private static boolean hasValidationAnnotation(AnnotatedElement obj, Class<?>[] validationGroups) {
        Preconditions.checkArgument((obj != null ? 1 : 0) != 0, (Object)"null obj");
        for (Annotation annotation : obj.getAnnotations()) {
            Class[] groups;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.isAnnotationPresent(Constraint.class)) continue;
            try {
                groups = (Class[])annotation.annotationType().getMethod("groups", new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                return true;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (groups == null || groups.length == 0) {
                return true;
            }
            return validationGroups == null || Util.isAnyGroupBeingValidated(groups, validationGroups);
        }
        return false;
    }

    public static boolean isGroupBeingValidated(Class<?> constraintGroup, Class<?>[] validationGroups) {
        Preconditions.checkArgument((constraintGroup != null ? 1 : 0) != 0, (Object)"null constraintGroup");
        Preconditions.checkArgument((validationGroups != null ? 1 : 0) != 0, (Object)"null validationGroups");
        for (Class<?> validationGroup : validationGroups) {
            Preconditions.checkArgument((validationGroup != null ? 1 : 0) != 0, (Object)"null validationGroup");
            if (!constraintGroup.isAssignableFrom(validationGroup)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyGroupBeingValidated(Class<?>[] constraintGroups, Class<?>[] validationGroups) {
        Preconditions.checkArgument((constraintGroups != null ? 1 : 0) != 0, (Object)"null constraintGroups");
        for (Class<?> constraintGroup : constraintGroups) {
            if (!Util.isGroupBeingValidated(constraintGroup, validationGroups)) continue;
            return true;
        }
        return false;
    }

    static <T> Method findJFieldSetterMethod(Class<T> type, Method getter) {
        Matcher matcher = Pattern.compile("(is|get)(.+)").matcher(getter.getName());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("can't infer setter method name from getter method " + getter.getName() + "() because name does not follow Java bean naming conventions");
        }
        String setterName = "set" + matcher.group(2);
        TypeToken typeType = TypeToken.of(type);
        TypeToken propertyType = typeType.resolveType(getter.getGenericReturnType());
        for (TypeToken superType : TypeToken.of(type).getTypes()) {
            for (Method setter : superType.getRawType().getDeclaredMethods()) {
                Type[] ptypes;
                if (!setter.getName().equals(setterName) || setter.getReturnType() != Void.TYPE || (ptypes = setter.getGenericParameterTypes()).length != 1 || !typeType.resolveType(ptypes[0]).equals((Object)propertyType)) continue;
                if ((setter.getModifiers() & 5) == 0 || (setter.getModifiers() & 2) != 0) {
                    throw new IllegalArgumentException("invalid setter method " + setterName + "() corresponding to getter method " + getter.getName() + "(): method must be public or protected");
                }
                return setter;
            }
        }
        throw new IllegalArgumentException("can't find any setter method " + setterName + "() corresponding to getter method " + getter.getName() + "() taking " + getter.getReturnType() + " and returning void");
    }

    static Map<MethodKey, Method> findAbstractMethods(Class<?> type) {
        HashMap<MethodKey, Method> map = new HashMap<MethodKey, Method>();
        for (TypeToken superType : TypeToken.of(type).getTypes()) {
            for (Method method : superType.getRawType().getDeclaredMethods()) {
                MethodKey key = new MethodKey(method);
                if (map.containsKey(key)) continue;
                map.put(key, method);
            }
        }
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if ((((Method)entry.getValue()).getModifiers() & 0x400) != 0) continue;
            i.remove();
        }
        return map;
    }

    public static TypeToken<?> findLowestCommonAncestorOfClasses(Iterable<Class<?>> types) {
        types.forEach(type -> {
            if (type == null) {
                throw new IllegalArgumentException("null type");
            }
        });
        return Util.findLowestCommonAncestor(Iterables.transform(types, TypeToken::of));
    }

    public static Set<TypeToken<?>> findLowestCommonAncestorsOfClasses(Iterable<Class<?>> types) {
        types.forEach(type -> {
            if (type == null) {
                throw new IllegalArgumentException("null type");
            }
        });
        return Util.findLowestCommonAncestors(Iterables.transform(types, TypeToken::of));
    }

    public static TypeToken<?> findLowestCommonAncestor(Iterable<TypeToken<?>> types) {
        Set<TypeToken<?>> supertypes = Util.findLowestCommonAncestors(types);
        TypeToken objectType = TypeToken.of(Object.class);
        supertypes.remove(objectType);
        switch (supertypes.size()) {
            case 0: {
                return objectType;
            }
            case 1: {
                return supertypes.iterator().next();
            }
        }
        for (TypeToken<?> supertype : supertypes) {
            if (supertype.getRawType().isInterface()) continue;
            return supertype;
        }
        return objectType;
    }

    public static Set<TypeToken<?>> findLowestCommonAncestors(Iterable<TypeToken<?>> types) {
        TypeToken supertype;
        HashSet supertypes = new HashSet();
        for (TypeToken<?> type : types) {
            Util.addSupertypes(supertypes, type);
        }
        Iterator<Object> i = supertypes.iterator();
        block1: while (i.hasNext()) {
            supertype = (TypeToken)i.next();
            for (TypeToken<?> type : types) {
                if (supertype.isSupertypeOf(type)) continue;
                i.remove();
                continue block1;
            }
        }
        i = supertypes.iterator();
        block3: while (i.hasNext()) {
            supertype = (TypeToken)i.next();
            for (TypeToken<?> supertype2 : supertypes) {
                if (supertype2.equals((Object)supertype) || !supertype.isSupertypeOf(supertype2)) continue;
                i.remove();
                continue block3;
            }
        }
        return supertypes;
    }

    private static <T> void addSupertypes(Set<TypeToken<?>> types, TypeToken<T> type) {
        if (type == null || !types.add(type)) {
            return;
        }
        Class rawType = type.getRawType();
        types.add(TypeToken.of((Class)rawType));
        types.add(Util.getWildcardedType(rawType));
        Class superclass = rawType.getSuperclass();
        if (superclass != null) {
            Util.addSupertypes(types, TypeToken.of(superclass));
            Util.addSupertypes(types, type.getSupertype(superclass));
        }
        for (Class<?> iface : rawType.getInterfaces()) {
            Util.addSupertypes(types, type.getSupertype(iface));
        }
    }

    public static <T> TypeToken<? extends T> getWildcardedType(Class<T> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        TypeVariable<Class<T>>[] typeVariables = type.getTypeParameters();
        if (typeVariables.length == 0) {
            return TypeToken.of(type);
        }
        Object[] questionMarks = new WildcardType[typeVariables.length];
        Arrays.fill(questionMarks, QUESTION_MARK);
        return Util.newParameterizedType(type, (Type[])questionMarks);
    }

    public static Type getTypeParameter(Type type, int index) {
        Preconditions.checkArgument((boolean)(type instanceof ParameterizedType), (Object)"type is missing generic type parameter(s)");
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] parameters = parameterizedType.getActualTypeArguments();
        if (index >= parameters.length) {
            throw new IllegalArgumentException("type is missing generic type parameter(s)");
        }
        return parameters[index];
    }

    public static Object invoke(Method method, Object target, Object ... params) {
        try {
            return method.invoke(target, params);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new JSimpleDBException("unexpected error invoking method " + method + " on " + target, e);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new JSimpleDBException("unexpected error invoking method " + method + " on " + target, e);
        }
    }

    public static <T> TypeToken<? extends T> newParameterizedType(Class<T> target, Type[] params) {
        Type type;
        try {
            if (newParameterizedTypeMethod == null) {
                newParameterizedTypeMethod = Class.forName("com.google.common.reflect.Types", false, Thread.currentThread().getContextClassLoader()).getDeclaredMethod("newParameterizedType", Class.class, Type[].class);
                newParameterizedTypeMethod.setAccessible(true);
            }
            type = (Type)newParameterizedTypeMethod.invoke(null, target, params);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected exception", e);
        }
        return TypeToken.of((Type)type);
    }
}

