/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.change;

import java.util.Objects;
import org.jsimpledb.JObject;
import org.jsimpledb.JTransaction;
import org.jsimpledb.change.ChangeSwitch;
import org.jsimpledb.change.FieldChange;

public class SimpleFieldChange<T, V>
extends FieldChange<T> {
    private final V oldValue;
    private final V newValue;

    public SimpleFieldChange(T jobj, int storageId, String fieldName, V oldValue, V newValue) {
        super(jobj, storageId, fieldName);
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public <R> R visit(ChangeSwitch<R> target) {
        return target.caseSimpleFieldChange(this);
    }

    @Override
    public void apply(JTransaction jtx, JObject jobj) {
        jtx.writeSimpleField(jobj, this.getStorageId(), this.newValue, false);
    }

    public V getOldValue() {
        return this.oldValue;
    }

    public V getNewValue() {
        return this.newValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SimpleFieldChange that = (SimpleFieldChange)obj;
        return Objects.equals(this.oldValue, that.oldValue) && Objects.equals(this.newValue, that.newValue);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Objects.hashCode(this.oldValue) ^ Objects.hashCode(this.newValue);
    }

    public String toString() {
        return "SimpleFieldChange[object=" + this.getObject() + ",field=\"" + this.getFieldName() + "\",oldValue=" + this.oldValue + ",newValue=" + this.newValue + "]";
    }
}

