/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import com.google.common.base.Preconditions;
import com.vaadin.data.Container;
import com.vaadin.ui.Table;
import java.util.ArrayList;
import org.dellroad.stuff.vaadin7.Connectable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTable<C extends Container & Connectable>
extends Table {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private C container;
    private ArrayList<String> columnIds;

    protected AbstractTable() {
    }

    protected AbstractTable(String caption) {
        super(caption);
    }

    protected void addColumn(String property, String name, int width, Table.Align alignment) {
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"null property");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        this.setColumnHeader(property, name);
        this.setColumnWidth(property, width);
        if (alignment != null) {
            this.setColumnAlignment(property, alignment);
        }
        this.columnIds.add(property);
    }

    public C getContainer() {
        return this.container;
    }

    protected abstract C buildContainer();

    protected abstract void configureColumns();

    public void attach() {
        super.attach();
        this.container = this.buildContainer();
        ((Connectable)this.container).connect();
        this.setContainerDataSource((Container)this.container);
        this.columnIds = new ArrayList();
        this.configureColumns();
        this.setVisibleColumns(this.columnIds.toArray());
    }

    public void detach() {
        if (this.container != null) {
            ((Connectable)this.container).disconnect();
            this.container = null;
        }
        super.detach();
    }
}

