/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;

public abstract class ConfirmWindow
extends Window {
    protected final Button okButton;
    protected final Button cancelButton;
    protected final UI ui;
    private boolean populated;

    protected ConfirmWindow(UI ui, String title) {
        this(ui, title, "OK", "Cancel");
    }

    protected ConfirmWindow(UI ui, String title, String okLabel) {
        this(ui, title, okLabel, "Cancel");
    }

    protected ConfirmWindow(UI ui, String title, String okLabel, String cancelLabel) {
        super(title);
        this.ui = ui;
        this.setWidth(450.0f, Sizeable.Unit.PIXELS);
        this.setHeight(300.0f, Sizeable.Unit.PIXELS);
        this.setClosable(true);
        this.setModal(true);
        this.okButton = okLabel != null ? new Button(okLabel, (Button.ClickListener & Serializable)e -> {
            if (this.execute()) {
                this.closeWindow();
            }
        }) : null;
        this.cancelButton = cancelLabel != null ? new Button(cancelLabel, (Button.ClickListener & Serializable)e -> this.closeWindow()) : null;
    }

    public void attach() {
        if (this.populated) {
            return;
        }
        this.populated = true;
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        layout.setSpacing(true);
        layout.setSizeFull();
        this.setContent((Component)layout);
        this.addContent(layout);
        Label spacer = new Label();
        layout.addComponent((Component)spacer);
        layout.setExpandRatio((Component)spacer, 1.0f);
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setSpacing(true);
        if (this.okButton != null) {
            buttonLayout.addComponent((Component)this.okButton);
        }
        if (this.cancelButton != null) {
            buttonLayout.addComponent((Component)this.cancelButton);
        }
        layout.addComponent((Component)buttonLayout);
    }

    public void show() {
        this.ui.addWindow((Window)this);
    }

    public void closeWindow() {
        this.ui.removeWindow((Window)this);
    }

    protected abstract void addContent(VerticalLayout var1);

    protected abstract boolean execute();
}

