/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import org.jsimpledb.JObject;
import org.jsimpledb.Session;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.ExprParser;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.util.CastFunction;
import org.jsimpledb.util.ParseContext;
import org.jsimpledb.vaadin.QueryJObjectContainer;

public class ExprQueryJObjectContainer
extends QueryJObjectContainer {
    protected final ParseSession session;
    private String contentExpression;

    public ExprQueryJObjectContainer(ParseSession session) {
        this(session, null);
    }

    public ExprQueryJObjectContainer(ParseSession session, Class<?> type) {
        super(session.getJSimpleDB(), type);
        this.session = session;
    }

    public void setContentExpression(String contentExpression) {
        this.contentExpression = contentExpression;
        this.reload();
    }

    @Override
    protected void doInTransaction(Runnable action) {
        this.session.performParseSessionAction(session2 -> action.run());
    }

    @Override
    protected Iterator<? extends JObject> queryForObjects() {
        Iterator iterator;
        if (this.contentExpression == null) {
            return Collections.emptyIterator();
        }
        ParseContext ctx = new ParseContext(this.contentExpression);
        Node node = new ExprParser().parse(this.session, ctx, false);
        ctx.skipWhitespace();
        if (!ctx.isEOF()) {
            throw new ParseException(ctx, "syntax error");
        }
        Object content = node.evaluate(this.session).get(this.session);
        if (content instanceof Iterator) {
            iterator = (Iterator)content;
        } else if (content instanceof Iterable) {
            iterator = ((Iterable)content).iterator();
        } else {
            throw new EvalException("expression must evaluate to an Iterable or Iterator; found " + (content != null ? content.getClass().getName() : "null") + " instead");
        }
        return Iterators.transform(iterator, (Function)new CastFunction(JObject.class).toGuava());
    }

    private static interface RetryableParseAction
    extends ParseSession.Action,
    Session.RetryableAction {
    }
}

