/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import com.google.common.base.Preconditions;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.combobox.FilteringMode;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.TextArea;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import org.jsimpledb.JClass;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.Session;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.vaadin.ExprQueryJObjectContainer;
import org.jsimpledb.vaadin.JObjectTable;
import org.jsimpledb.vaadin.SizedLabel;
import org.jsimpledb.vaadin.SortKeyContainer;
import org.jsimpledb.vaadin.TypeContainer;
import org.jsimpledb.vaadin.TypeTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JObjectChooser
implements Property.ValueChangeNotifier {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Button showButton = new Button("Show", (Button.ClickListener & Serializable)e -> this.showButtonClicked());
    private final CheckBox reverseCheckBox = new CheckBox("Reverse sort");
    private final JSimpleDB jdb;
    private final ParseSession session;
    private final boolean showFields;
    private final TypeContainer typeContainer;
    private final ExprQueryJObjectContainer objectContainer;
    private final HashSet<Property.ValueChangeListener> listeners = new HashSet();
    private final HorizontalSplitPanel splitPanel = new HorizontalSplitPanel();
    private final FormLayout showForm = new FormLayout();
    private final TypeTable typeTable;
    private final TextArea exprField = new TextArea();
    private final ComboBox sortComboBox = new ComboBox();
    private JObjectTable objectTable;
    private SortKeyContainer sortKeyContainer;

    public JObjectChooser(ParseSession session, Class<?> type, boolean showFields) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"null session");
        this.jdb = session.getJSimpleDB();
        this.session = session;
        this.showFields = showFields;
        this.typeContainer = new TypeContainer(this.jdb, type);
        this.typeTable = new TypeTable(this.typeContainer);
        this.objectContainer = new ExprQueryJObjectContainer(this.session, this.typeContainer.getRootType());
        this.splitPanel.setWidth("100%");
        this.splitPanel.setHeight(300.0f, Sizeable.Unit.PIXELS);
        this.splitPanel.setFirstComponent((Component)this.typeTable);
        this.splitPanel.setSecondComponent((Component)new SizedLabel(" "));
        this.splitPanel.setSplitPosition(20.0f);
        this.showForm.setMargin(false);
        this.showForm.setWidth("100%");
        HorizontalLayout sortLayout = new HorizontalLayout();
        sortLayout.setCaption("Sort by:");
        sortLayout.setSpacing(true);
        sortLayout.setMargin(false);
        this.sortComboBox.setNullSelectionAllowed(false);
        this.sortComboBox.setNewItemsAllowed(false);
        this.sortComboBox.setTextInputAllowed(false);
        this.sortComboBox.setFilteringMode(FilteringMode.OFF);
        this.sortComboBox.setItemCaptionMode(AbstractSelect.ItemCaptionMode.PROPERTY);
        this.sortComboBox.setItemCaptionPropertyId((Object)"description");
        this.sortComboBox.setImmediate(true);
        this.reverseCheckBox.setImmediate(true);
        sortLayout.addComponent((Component)this.sortComboBox);
        sortLayout.addComponent((Component)this.reverseCheckBox);
        this.showForm.addComponent((Component)sortLayout);
        this.exprField.setCaption("Expression:");
        this.exprField.setRows(6);
        this.exprField.setWidth("100%");
        this.exprField.addStyleName("jsdb-fixed-width");
        this.showForm.addComponent((Component)this.exprField);
        this.showForm.addComponent((Component)this.showButton);
        this.typeTable.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.selectType((Class)e.getProperty().getValue(), false));
        Property.ValueChangeListener & Serializable sortListener = (Property.ValueChangeListener & Serializable)e -> this.selectSort();
        this.sortComboBox.addValueChangeListener((Property.ValueChangeListener)sortListener);
        this.reverseCheckBox.addValueChangeListener((Property.ValueChangeListener)sortListener);
        this.selectType(type != null ? type : this.typeContainer.getRootType(), true);
    }

    public ParseSession getParseSession() {
        return this.session;
    }

    public ExprQueryJObjectContainer getJObjectContainer() {
        return this.objectContainer;
    }

    public Class<?> getType() {
        return this.objectContainer.getType();
    }

    public TypeTable getTypeTable() {
        return this.typeTable;
    }

    public HorizontalSplitPanel getObjectPanel() {
        return this.splitPanel;
    }

    public ObjId getObjId() {
        return this.objectTable != null ? (ObjId)this.objectTable.getValue() : null;
    }

    public FormLayout getShowForm() {
        return this.showForm;
    }

    public JClass<?> getJClass() {
        Class<?> type = this.objectContainer.getType();
        if (type == null) {
            return null;
        }
        try {
            return this.jdb.getJClass(type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void addValueChangeListener(Property.ValueChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"null listener");
        this.listeners.add(listener);
        if (this.objectTable != null) {
            this.objectTable.addValueChangeListener(listener);
        }
    }

    public void removeValueChangeListener(Property.ValueChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.objectTable != null) {
            this.objectTable.removeValueChangeListener(listener);
        }
    }

    public void addListener(Property.ValueChangeListener listener) {
        this.addValueChangeListener(listener);
    }

    public void removeListener(Property.ValueChangeListener listener) {
        this.removeValueChangeListener(listener);
    }

    private void selectType(Class<?> type, boolean force) {
        if (type == null) {
            return;
        }
        if (!this.setNewType(!type.equals(Object.class) ? type : null, force)) {
            return;
        }
        SortKeyContainer.SortKey previousSort = (SortKeyContainer.SortKey)this.sortComboBox.getValue();
        JClass<?> jclass = this.getJClass();
        this.sortKeyContainer = jclass != null ? new SortKeyContainer(this.jdb, jclass) : new SortKeyContainer(this.jdb, this.objectContainer.getType());
        this.sortComboBox.setContainerDataSource((Container)this.sortKeyContainer);
        SortKeyContainer.SortKey newSort = (SortKeyContainer.SortKey)this.sortKeyContainer.getJavaObject(previousSort);
        if (newSort == null) {
            newSort = new SortKeyContainer.ObjectIdSortKey(this.sortKeyContainer);
        }
        this.sortComboBox.setValue((Object)newSort);
        this.selectSort();
        this.showObjects();
    }

    private void selectSort() {
        this.selectSort((SortKeyContainer.SortKey)this.sortComboBox.getValue(), (Boolean)this.reverseCheckBox.getValue());
    }

    private void selectSort(SortKeyContainer.SortKey sortKey, boolean reverse) {
        if (sortKey == null) {
            return;
        }
        this.exprField.setValue(sortKey.getExpression(this.session, null, reverse));
        this.showObjects();
    }

    private void showButtonClicked() {
        this.setNewType(null, false);
        this.typeTable.setValue(null);
        this.showObjects();
    }

    private void showObjects() {
        this.objectContainer.setContentExpression((String)this.exprField.getValue());
    }

    private boolean setNewType(Class<?> type, boolean force) {
        Class<?> currentType = this.objectContainer.getType();
        if (!force && (currentType != null ? currentType.equals(type) : type == null)) {
            return false;
        }
        if (this.objectTable != null) {
            for (Property.ValueChangeListener listener : this.listeners) {
                this.objectTable.removeValueChangeListener(listener);
            }
            this.splitPanel.removeComponent((Component)this.objectTable);
        }
        this.objectContainer.setType(type);
        this.objectContainer.load(Collections.emptySet());
        this.objectTable = new JObjectTable(this.jdb, this.objectContainer, (Session)this.session, this.showFields);
        for (Property.ValueChangeListener listener : this.listeners) {
            this.objectTable.addValueChangeListener(listener);
        }
        this.splitPanel.setSecondComponent((Component)this.objectTable);
        this.objectTable.setValue(null);
        Property.ValueChangeEvent event = new Property.ValueChangeEvent(){

            public Property<?> getProperty() {
                return JObjectChooser.this.objectTable;
            }
        };
        for (Property.ValueChangeListener listener : new HashSet<Property.ValueChangeListener>(this.listeners)) {
            try {
                listener.valueChange(event);
            }
            catch (Exception e) {
                this.log.error("exception thrown by value change listener", (Throwable)e);
            }
        }
        return true;
    }
}

