/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import com.google.common.base.Preconditions;
import com.vaadin.ui.DefaultFieldFactory;
import com.vaadin.ui.Table;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.Session;
import org.jsimpledb.vaadin.AbstractTable;
import org.jsimpledb.vaadin.JObjectContainer;

public class JObjectTable
extends AbstractTable<JObjectContainer> {
    private final JSimpleDB jdb;
    private final JObjectContainer container;
    private final Session session;
    private final boolean showFields;

    public JObjectTable(JSimpleDB jdb, JObjectContainer container, Session session) {
        this(jdb, container, session, true);
    }

    public JObjectTable(JSimpleDB jdb, JObjectContainer container, Session session, boolean showFields) {
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        Preconditions.checkArgument((container != null ? 1 : 0) != 0, (Object)"null container");
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"null session");
        this.jdb = jdb;
        this.container = container;
        this.session = session;
        this.showFields = showFields;
        this.setSelectable(true);
        this.setImmediate(true);
        this.setSizeFull();
    }

    @Override
    protected JObjectContainer buildContainer() {
        return this.container;
    }

    @Override
    protected void configureColumns() {
        this.setColumnCollapsingAllowed(true);
        for (String propertyName : ((JObjectContainer)((Object)this.getContainer())).getOrderedPropertyNames()) {
            String title = DefaultFieldFactory.createCaptionByPropertyId((Object)propertyName);
            Table.Align align = Table.Align.CENTER;
            int width = 120;
            boolean showField = this.showFields;
            switch (propertyName) {
                case "$label": {
                    title = "Label";
                    width = 120;
                    showField = true;
                    break;
                }
                case "$objId": {
                    title = "ID";
                    width = 120;
                    showField = false;
                    break;
                }
                case "$type": {
                    title = "Type";
                    width = 80;
                    break;
                }
                case "$version": {
                    title = "Schema Version";
                    width = 40;
                    showField = false;
                    break;
                }
            }
            this.addColumn(propertyName, title, width, align);
            this.setColumnExpandRatio(propertyName, (float)width / 120.0f);
            this.setColumnCollapsed(propertyName, !showField);
        }
    }
}

