/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import com.google.common.base.Preconditions;
import com.vaadin.data.util.converter.Converter;
import java.util.Locale;
import org.jsimpledb.core.FieldType;

public class SimpleFieldConverter<T>
implements Converter<String, T> {
    private final FieldType<T> fieldType;

    public SimpleFieldConverter(FieldType<T> fieldType) {
        Preconditions.checkArgument((fieldType != null ? 1 : 0) != 0, (Object)"null fieldType");
        this.fieldType = fieldType;
    }

    public Class<String> getPresentationType() {
        return String.class;
    }

    public Class<T> getModelType() {
        return this.fieldType.getTypeToken().getRawType();
    }

    public String convertToPresentation(T value, Class<? extends String> targetType, Locale locale) {
        if (value == null) {
            return null;
        }
        return this.fieldType.toString(value);
    }

    public T convertToModel(String value, Class<? extends T> targetType, Locale locale) {
        if (value == null) {
            return null;
        }
        try {
            return (T)this.fieldType.fromString(value.trim());
        }
        catch (IllegalArgumentException e) {
            throw new Converter.ConversionException("invalid value of type `" + this.fieldType + "': " + e.getMessage());
        }
    }
}

