/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import com.vaadin.ui.DefaultFieldFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedMap;
import org.dellroad.stuff.string.StringEncoder;
import org.dellroad.stuff.vaadin7.ProvidesProperty;
import org.dellroad.stuff.vaadin7.SelfKeyedContainer;
import org.jsimpledb.JClass;
import org.jsimpledb.JComplexField;
import org.jsimpledb.JField;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.vaadin.Util;

class SortKeyContainer
extends SelfKeyedContainer<SortKey> {
    public static final String DESCRIPTION_PROPERTY = "description";
    private final JSimpleDB jdb;
    private final JClass<?> jclass;
    private final Class<?> type;

    SortKeyContainer(JSimpleDB jdb, JClass<?> jclass) {
        this(jdb, jclass, jclass.getType());
    }

    SortKeyContainer(JSimpleDB jdb, Class<?> type) {
        this(jdb, null, type);
    }

    private SortKeyContainer(JSimpleDB jdb, JClass<?> jclass, Class<?> type) {
        super(SortKey.class);
        this.jdb = jdb;
        this.jclass = jclass;
        this.type = type;
        ArrayList<SortKey> sortKeys = new ArrayList<SortKey>();
        sortKeys.add(new ObjectIdSortKey());
        sortKeys.add(new VersionSortKey());
        SortedMap<Integer, JField> commonFields = Util.getCommonJFields(this.jdb.getJClasses(this.type));
        if (commonFields != null) {
            for (JField jfield : commonFields.values()) {
                if (jfield instanceof JComplexField) {
                    ((JComplexField)jfield).getSubFields().stream().filter(subField -> subField.isIndexed()).map(x$0 -> new FieldSortKey((JSimpleField)x$0)).forEach(sortKeys::add);
                    continue;
                }
                if (!(jfield instanceof JSimpleField) || !((JSimpleField)jfield).isIndexed()) continue;
                sortKeys.add(new FieldSortKey((JSimpleField)jfield));
            }
        }
        Collections.sort(sortKeys.subList(2, sortKeys.size()), Comparator.comparing(SortKey::getDescription));
        this.load(sortKeys);
    }

    private String getTypeExpression(ParseSession session, boolean defaultJObject) {
        return this.jclass != null ? this.jclass.getName() : (this.type != null ? session.relativizeClassName(this.type) + ".class" : (defaultJObject ? session.relativizeClassName(Object.class) + ".class" : ""));
    }

    class FieldSortKey
    extends SortKey {
        private final int storageId;
        private final String fieldName;
        private final Class<?> fieldType;
        private final boolean isSubField;

        FieldSortKey(JSimpleField jfield) {
            super((jfield.getParentField() != null ? DefaultFieldFactory.createCaptionByPropertyId((Object)jfield.getParentField().getName()) + "." : "") + DefaultFieldFactory.createCaptionByPropertyId((Object)jfield.getName()));
            this.storageId = jfield.getStorageId();
            this.isSubField = jfield.getParentField() != null;
            this.fieldName = (this.isSubField ? jfield.getParentField().getName() + "." : "") + jfield.getName();
            this.fieldType = jfield.getTypeToken().wrap().getRawType();
        }

        @Override
        public String getExpression(ParseSession session, JObject startingPoint, boolean reverse) {
            String expr = "queryIndex(" + SortKeyContainer.this.getTypeExpression(session, true) + ", " + StringEncoder.enquote((String)this.fieldName) + ", " + session.relativizeClassName(this.fieldType) + ".class).asMap()";
            if (reverse) {
                expr = expr + ".descendingMap()";
            }
            expr = expr + ".values()";
            expr = "concat(\n  " + expr + ")";
            return expr;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            FieldSortKey that = (FieldSortKey)obj;
            return this.storageId == that.storageId && this.isSubField == that.isSubField;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.storageId ^ (this.isSubField ? 1 : 0);
        }
    }

    class VersionSortKey
    extends SortKey {
        VersionSortKey() {
            super("Schema Version");
        }

        @Override
        public String getExpression(ParseSession session, JObject startingPoint, boolean reverse) {
            String expr = "queryVersion(" + SortKeyContainer.this.getTypeExpression(session, false) + ")";
            if (reverse) {
                expr = expr + ".descendingMap()";
            }
            expr = expr + ".values()";
            expr = "concat(\n  " + expr + ")";
            return expr;
        }
    }

    class ObjectIdSortKey
    extends SortKey {
        ObjectIdSortKey() {
            super("Object ID");
        }

        @Override
        public String getExpression(ParseSession session, JObject startingPoint, boolean reverse) {
            String expr = "all(" + SortKeyContainer.this.getTypeExpression(session, false) + ")";
            if (reverse) {
                expr = expr + ".descendingSet()";
            }
            return expr;
        }
    }

    abstract class SortKey {
        private final String description;

        SortKey(String description) {
            this.description = description;
        }

        @ProvidesProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj != null && obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public String toString() {
            return "SortKey[" + this.description + "]";
        }

        public abstract String getExpression(ParseSession var1, JObject var2, boolean var3);
    }
}

