/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import com.google.common.base.Preconditions;
import com.vaadin.data.Container;
import com.vaadin.shared.ui.label.ContentMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.dellroad.stuff.vaadin7.ProvidesProperty;
import org.dellroad.stuff.vaadin7.SimpleKeyedContainer;
import org.jsimpledb.JClass;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.Util;
import org.jsimpledb.vaadin.SizedLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeContainer
extends SimpleKeyedContainer<Class<?>, Node>
implements Container.Hierarchical {
    public static final String NAME_PROPERTY = "name";
    public static final String STORAGE_ID_PROPERTY = "storageId";
    public static final String TYPE_PROPERTY = "type";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final JSimpleDB jdb;
    private final Class<?> rootType;
    private final ArrayList<Node> rootList = new ArrayList();

    public TypeContainer(JSimpleDB jdb) {
        this(jdb, null);
    }

    public TypeContainer(JSimpleDB jdb, Class<?> type) {
        super(Node.class);
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        this.jdb = jdb;
        HashSet types = this.jdb.getJClasses().values().stream().filter(jclass -> type == null || type.isAssignableFrom(jclass.getType())).map(JClass::getType).collect(Collectors.toCollection(HashSet::new));
        this.rootType = !types.isEmpty() ? Util.findLowestCommonAncestorOfClasses((Iterable)types).getRawType() : Object.class;
    }

    public void connect() {
        super.connect();
        this.reload();
    }

    public Class<?> getKeyFor(Node node) {
        return node.getType();
    }

    public Class<?> getRootType() {
        return this.rootType;
    }

    public void reload() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        boolean addedRoot = false;
        for (JClass jclass : this.jdb.getJClasses().values()) {
            if (!this.rootType.isAssignableFrom(jclass.getType())) continue;
            nodes.add(new Node(jclass));
            if (jclass.getType() != this.rootType) continue;
            addedRoot = true;
        }
        if (!addedRoot) {
            nodes.add(new Node(this.rootType));
        }
        Collections.sort(nodes, Comparator.comparing(Node::propertyName));
        for (Node node1 : nodes) {
            Class<?> type1 = node1.getType();
            for (Node node2 : nodes) {
                Node previous;
                Class<?> type2;
                if (node2 == node1 || !(type2 = node2.getType()).isAssignableFrom(type1) || (previous = node1.getParent()) != null && !previous.getType().isAssignableFrom(type2)) continue;
                node1.setParent(node2);
            }
        }
        this.rootList.clear();
        for (Node node : nodes) {
            if (node.getParent() != null) {
                node.getParent().getChilds().add(node);
                continue;
            }
            this.rootList.add(node);
        }
        this.load(nodes);
    }

    public Set<Class<?>> getChildren(Object itemId) {
        Node node = (Node)this.getJavaObject(itemId);
        return node != null ? node.getChilds().stream().map(Node::getType).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public Class<?> getParent(Object itemId) {
        Node child = (Node)this.getJavaObject(itemId);
        if (child == null) {
            return null;
        }
        Node parent = child.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getType();
    }

    public Set<Class<?>> rootItemIds() {
        return this.rootList.stream().map(Node::getType).collect(Collectors.toSet());
    }

    public boolean areChildrenAllowed(Object itemId) {
        Node node = (Node)this.getJavaObject(itemId);
        return node != null && !node.getChilds().isEmpty();
    }

    public boolean isRoot(Object itemId) {
        Node node = (Node)this.getJavaObject(itemId);
        return node != null && node.getParent() == null;
    }

    public boolean hasChildren(Object itemId) {
        Node node = (Node)this.getJavaObject(itemId);
        return node != null && !node.getChilds().isEmpty();
    }

    public boolean setParent(Object itemId, Object newParentId) {
        throw new UnsupportedOperationException();
    }

    public boolean setChildrenAllowed(Object itemId, boolean areChildrenAllowed) {
        throw new UnsupportedOperationException();
    }

    public boolean removeItem(Object itemId) {
        throw new UnsupportedOperationException();
    }

    public static class Node {
        private final Class<?> type;
        private final JClass<?> jclass;
        private final ArrayList<Node> childs = new ArrayList();
        private Node parent;

        public Node(JClass<?> jclass) {
            this(jclass.getType(), jclass);
        }

        public Node(Class<?> type) {
            this(type, null);
        }

        private Node(Class<?> type, JClass<?> jclass) {
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
            this.type = type;
            this.jclass = jclass;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public List<Node> getChilds() {
            return this.childs;
        }

        @ProvidesProperty(value="name")
        public String propertyName() {
            return this.jclass != null ? this.jclass.getName() : this.type.getSimpleName();
        }

        @ProvidesProperty(value="storageId")
        public Integer propertyStorageId() {
            return this.jclass != null ? Integer.valueOf(this.jclass.getStorageId()) : null;
        }

        @ProvidesProperty(value="type")
        public SizedLabel proeprtyType() {
            return new SizedLabel("<code>" + this.getType().toString() + "</code>", ContentMode.HTML);
        }
    }
}

