/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.bdb;

import com.google.common.base.Preconditions;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVDatabaseException;
import org.jsimpledb.kv.bdb.BerkeleyKVTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyKVDatabase
implements KVDatabase {
    public static final String DEFAULT_DATABASE_NAME = "JSimpleDB";
    private static final ThreadLocal<TransactionConfig> NEXT_TX_CONFIG = new ThreadLocal();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DatabaseConfig databaseConfig = new DatabaseConfig().setAllowCreate(true).setTransactional(true);
    private final HashSet<BerkeleyKVTransaction> openTransactions = new HashSet();
    private EnvironmentConfig environmentConfig = new EnvironmentConfig().setAllowCreate(true).setTransactional(true).setTxnSerializableIsolation(true);
    private TransactionConfig defaultTransactionConfig = TransactionConfig.DEFAULT;
    private File directory;
    private String databaseName = "JSimpleDB";
    private Environment environment;
    private Database database;

    public synchronized File getDirectory() {
        return this.directory;
    }

    public synchronized void setDirectory(File directory) {
        this.directory = directory;
    }

    public synchronized String getDatabaseName() {
        return this.databaseName;
    }

    public synchronized void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public synchronized EnvironmentConfig getEnvironmentConfig() {
        return this.environmentConfig.clone();
    }

    public synchronized void setEnvironmentConfig(EnvironmentConfig config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"null config");
        Preconditions.checkArgument((boolean)config.getTransactional(), (Object)"environment config must be transactional");
        this.environmentConfig = config;
    }

    public synchronized TransactionConfig getTransactionConfig() {
        return this.defaultTransactionConfig.clone();
    }

    public synchronized void setTransactionConfig(TransactionConfig config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"null config");
        this.defaultTransactionConfig = config;
    }

    public void setNextTransactionConfig(TransactionConfig config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"null config");
        NEXT_TX_CONFIG.set(config);
    }

    public synchronized DatabaseConfig getDatabaseConfig() {
        return this.databaseConfig.clone();
    }

    public synchronized void setDatabaseConfig(DatabaseConfig config) {
        this.databaseConfig.setAllowCreate(config.getAllowCreate()).setCacheMode(config.getCacheMode()).setDeferredWrite(config.getDeferredWrite()).setExclusiveCreate(config.getExclusiveCreate()).setNodeMaxEntries(config.getNodeMaxEntries()).setReadOnly(config.getReadOnly()).setReplicated(config.getReplicated()).setTemporary(config.getTemporary());
    }

    public synchronized Environment getEnvironment() {
        Preconditions.checkState((this.environment != null ? 1 : 0) != 0, (Object)"not started");
        assert (this.database != null);
        return this.environment;
    }

    public synchronized Database getDatabase() {
        Preconditions.checkState((this.environment != null ? 1 : 0) != 0, (Object)"not started");
        assert (this.database != null);
        return this.database;
    }

    public BerkeleyKVTransaction createTransaction(Map<String, ?> options) {
        return this.createTransaction();
    }

    public synchronized BerkeleyKVTransaction createTransaction() {
        Transaction bdbTx;
        Preconditions.checkState((this.environment != null ? 1 : 0) != 0, (Object)"not started");
        assert (this.database != null);
        TransactionConfig config = NEXT_TX_CONFIG.get();
        if (config == null) {
            config = this.defaultTransactionConfig;
        } else {
            NEXT_TX_CONFIG.remove();
        }
        try {
            bdbTx = this.environment.beginTransaction(null, config);
        }
        catch (DatabaseException e) {
            throw new KVDatabaseException((KVDatabase)this, (Throwable)e);
        }
        BerkeleyKVTransaction tx = new BerkeleyKVTransaction(this, bdbTx);
        this.openTransactions.add(tx);
        return tx;
    }

    synchronized void removeTransaction(BerkeleyKVTransaction tx) {
        this.openTransactions.remove(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostConstruct
    public synchronized void start() {
        assert (this.environment == null == (this.database == null));
        if (this.environment != null) {
            return;
        }
        assert (this.openTransactions.isEmpty());
        Preconditions.checkState((this.directory != null ? 1 : 0) != 0, (Object)"no directory configured");
        Preconditions.checkState((this.databaseName != null ? 1 : 0) != 0, (Object)"no database name configured");
        boolean success = false;
        try {
            this.environment = new Environment(this.directory, this.environmentConfig);
            this.database = this.environment.openDatabase(null, this.databaseName, this.databaseConfig);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            try {
                for (AutoCloseable item : new AutoCloseable[]{this.database, this.environment}) {
                    if (item == null) continue;
                    try {
                        item.close();
                    }
                    catch (Throwable e) {
                        this.log.error("caught exception cleaning up after failed startup (ignoring)", e);
                    }
                }
                throw throwable;
            }
            finally {
                this.database = null;
                this.environment = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stop() {
        ArrayList<BerkeleyKVTransaction> oldTransactions;
        Database oldDatabase;
        Environment oldEnvironment;
        BerkeleyKVDatabase berkeleyKVDatabase = this;
        synchronized (berkeleyKVDatabase) {
            assert (this.environment == null == (this.database == null));
            oldEnvironment = this.environment;
            oldDatabase = this.database;
            oldTransactions = new ArrayList<BerkeleyKVTransaction>(this.openTransactions);
            this.environment = null;
            this.database = null;
            this.openTransactions.clear();
        }
        if (oldEnvironment == null) {
            return;
        }
        for (BerkeleyKVTransaction tx : oldTransactions) {
            try {
                tx.rollback();
            }
            catch (Throwable e) {
                this.log.debug("caught exception closing open transaction during shutdown (ignoring)", e);
            }
        }
        try {
            oldDatabase.close();
        }
        catch (Throwable e) {
            this.log.error("caught exception closing database during shutdown (ignoring)", e);
        }
        try {
            oldEnvironment.close();
        }
        catch (Throwable e) {
            this.log.error("caught exception closing environment during shutdown (ignoring)", e);
        }
    }
}

