/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.bdb;

import java.io.File;
import java.util.ArrayDeque;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVImplementation;
import org.jsimpledb.kv.bdb.BerkeleyKVDatabase;
import org.jsimpledb.kv.mvcc.AtomicKVStore;

public class BerkeleyKVImplementation
extends KVImplementation {
    public String[][] getCommandLineOptions() {
        return new String[][]{{"--bdb directory", "Use Berkeley DB Java Edition key/value database in specified directory"}, {"--bdb-database name", "Specify Berkeley DB database name (default `JSimpleDB')"}};
    }

    public Config parseCommandLineOptions(ArrayDeque<String> options) {
        String dir = this.parseCommandLineOption(options, "--bdb");
        if (dir == null) {
            return null;
        }
        Config config = new Config(new File(dir));
        String dbname = this.parseCommandLineOption(options, "--bdb-database");
        if (dbname != null) {
            config.setDatabaseName(dbname);
        }
        return config;
    }

    public BerkeleyKVDatabase createKVDatabase(Object configuration, KVDatabase kvdb, AtomicKVStore kvstore) {
        Config config = (Config)configuration;
        BerkeleyKVDatabase bdb = new BerkeleyKVDatabase();
        bdb.setDirectory(config.getDirectory());
        bdb.setDatabaseName(config.getDatabaseName());
        return bdb;
    }

    public String getDescription(Object configuration) {
        return "BerkeleyDB " + ((Config)configuration).getDirectory().getName();
    }

    private static class Config {
        private File dir;
        private String databaseName = "JSimpleDB";

        Config(File dir) {
            if (dir == null) {
                throw new IllegalArgumentException("null dir");
            }
            this.dir = dir;
        }

        public File getDirectory() {
            return this.dir;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }
    }
}

