/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.cockroach;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.cockroach.CockroachKVTransaction;
import org.jsimpledb.kv.sql.SQLKVDatabase;
import org.jsimpledb.kv.sql.SQLKVTransaction;

public class CockroachKVDatabase
extends SQLKVDatabase {
    public CockroachKVDatabase() {
        this.setRollbackForReadOnly(false);
    }

    protected void initializeDatabaseIfNecessary(Connection connection) throws SQLException {
        String sql = "CREATE TABLE IF NOT EXISTS " + this.quote(this.getTableName()) + " (\n  " + this.quote(this.getKeyColumnName()) + " BYTES PRIMARY KEY NOT NULL,\n  " + this.quote(this.getValueColumnName()) + " BYTES NOT NULL\n)";
        try (Statement statement = connection.createStatement();){
            this.log.debug("auto-creating table `" + this.getTableName() + "' if not already existing:\n{}", (Object)sql);
            statement.execute(sql);
        }
    }

    protected void beginTransaction(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    protected void postBeginTransaction(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("SET TRANSACTION ISOLATION LEVEL " + this.isolationLevel.name().replace('_', ' '));
        }
    }

    protected CockroachKVTransaction createSQLKVTransaction(Connection connection) throws SQLException {
        return new CockroachKVTransaction(this, connection);
    }

    public String createPutStatement() {
        return "UPSERT INTO " + this.quote(this.tableName) + " (" + this.quote(this.keyColumnName) + ", " + this.quote(this.valueColumnName) + ") VALUES (?, ?)";
    }

    public String quote(String name) {
        return "\"" + name + "\"";
    }

    public String limitSingleRow(String sql) {
        return sql + " LIMIT 1";
    }

    public KVTransactionException wrapException(SQLKVTransaction tx, SQLException e) {
        String state;
        switch (state = e.getSQLState()) {
            case "55P03": 
            case "40P01": 
            case "CR000": {
                return new RetryTransactionException((KVTransaction)tx, (Throwable)e);
            }
        }
        if (e.getMessage().contains("restart transaction")) {
            return new RetryTransactionException((KVTransaction)tx, (Throwable)e);
        }
        return super.wrapException(tx, e);
    }
}

