/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.sql;

import javax.sql.DataSource;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVImplementation;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.kv.sql.SQLKVDatabase;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public abstract class SQLDriverKVImplementation
extends KVImplementation {
    private final String driverClassName;

    protected SQLDriverKVImplementation(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public KVDatabase createKVDatabase(Object configuration, KVDatabase kvdb, AtomicKVStore kvstore) {
        try {
            Class.forName(this.driverClassName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("can't load SQL driver class `" + this.driverClassName + "'", e);
        }
        String jdbcUrl = this.getJdbcUrl(configuration);
        SQLKVDatabase sqlKV = this.createSQLKVDatabase(configuration);
        sqlKV.setDataSource((DataSource)new DriverManagerDataSource(jdbcUrl));
        return sqlKV;
    }

    protected abstract SQLKVDatabase createSQLKVDatabase(Object var1);

    protected String getJdbcUrl(Object configuration) {
        return (String)configuration;
    }
}

