/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import org.jsimpledb.core.ComplexField;
import org.jsimpledb.core.Field;
import org.jsimpledb.core.FieldSwitch;
import org.jsimpledb.core.FieldSwitchAdapter;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.core.SchemaItem;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.parse.ObjTypeParser;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.SpaceParser;
import org.jsimpledb.util.ParseContext;

public class IndexedFieldParser
implements Parser<Result> {
    private final SpaceParser spaceParser = new SpaceParser();
    private final Predicate<Field<?>> hasIndexedPredicate = field -> field instanceof SimpleField ? ((SimpleField)field).isIndexed() : (field instanceof ComplexField ? ((ComplexField)field).getSubFields().stream().anyMatch(SimpleField::isIndexed) : false);

    @Override
    public Result parse(ParseSession session, final ParseContext ctx, boolean complete) {
        ObjType objType = new ObjTypeParser().parse(session, ctx, complete);
        ctx.skipWhitespace();
        if (!ctx.tryLiteral(".")) {
            throw new ParseException(ctx, "expected field name").addCompletion(".");
        }
        ctx.skipWhitespace();
        Matcher fieldMatcher = ctx.tryPattern("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
        if (fieldMatcher == null) {
            throw new ParseException(ctx, "expected field name").addCompletions(objType.getFields().values().stream().filter(this.hasIndexedPredicate).map(SchemaItem::getName));
        }
        final String fieldName = fieldMatcher.group();
        Field<?> field = objType.getFields().values().stream().filter(f -> f.getName().equals(fieldName)).filter(this.getFieldFilter()).findAny().orElseThrow(() -> new ParseException(ctx, "error accessing field `" + fieldName + "': there is no such indexed field in " + objType).addCompletions(ParseUtil.complete(objType.getFields().values().stream().filter(this.getFieldFilter()).filter(this.hasIndexedPredicate).map(SchemaItem::getName), fieldName)));
        return (Result)field.visit((FieldSwitch)new FieldSwitchAdapter<Result>(){

            protected <T> Result caseComplexField(ComplexField<T> field) {
                ctx.skipWhitespace();
                if (!ctx.tryLiteral(".")) {
                    throw new ParseException(ctx, "expected sub-field name").addCompletion(".");
                }
                Matcher subfieldMatcher = ctx.tryPattern("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
                if (subfieldMatcher == null) {
                    throw new ParseException(ctx, "expected sub-field name").addCompletions(field.getSubFields().stream().filter(SimpleField::isIndexed).map(SchemaItem::getName));
                }
                String subFieldName = subfieldMatcher.group();
                SimpleField<?> subField = field.getSubFields().stream().filter(f -> f.getName().equals(subFieldName)).filter(IndexedFieldParser.this.getSubFieldFilter()).findAny().orElseThrow(() -> new ParseException(ctx, "unknown sub-field `" + subFieldName + "' of complex field `" + fieldName + "'").addCompletions(ParseUtil.complete(field.getSubFields().stream().filter(IndexedFieldParser.this.getSubFieldFilter()).filter(SimpleField::isIndexed).map(SchemaItem::getName), fieldName)));
                return new Result(fieldName + "." + subFieldName, this.verifyIndexedSimple((Field<?>)subField), field);
            }

            protected <T> Result caseField(Field<T> field) {
                return new Result(fieldName, this.verifyIndexedSimple(field));
            }

            private SimpleField<?> verifyIndexedSimple(Field<?> field) {
                if (!(field instanceof SimpleField) || !((SimpleField)field).isIndexed()) {
                    throw new ParseException(ctx, "expected indexed field");
                }
                return (SimpleField)field;
            }
        });
    }

    protected Predicate<? super Field<?>> getFieldFilter() {
        return field -> true;
    }

    protected Predicate<? super SimpleField<?>> getSubFieldFilter() {
        return subField -> true;
    }

    public static class Result {
        private final String fieldName;
        private final SimpleField<?> field;
        private final ComplexField<?> parentField;

        Result(String fieldName, SimpleField<?> field) {
            this(fieldName, field, null);
        }

        Result(String fieldName, SimpleField<?> field, ComplexField<?> parentField) {
            this.fieldName = fieldName;
            this.field = field;
            this.parentField = parentField;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public SimpleField<?> getField() {
            return this.field;
        }

        public ComplexField<?> getParentField() {
            return this.parentField;
        }
    }
}

