/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NavigableSet;
import java.util.regex.Matcher;
import org.jsimpledb.Session;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.util.NavigableSets;
import org.jsimpledb.util.ParseContext;

public class ObjIdParser
implements Parser<ObjId> {
    public static final int MAX_COMPLETE_OBJECTS = 100;

    @Override
    public ObjId parse(ParseSession session, ParseContext ctx, boolean complete) {
        Matcher matcher = ctx.tryPattern("([0-9A-Fa-f]{0,16})");
        if (matcher == null) {
            throw new ParseException(ctx, "invalid object ID");
        }
        String param = matcher.group(1);
        try {
            return new ObjId(param);
        }
        catch (IllegalArgumentException e) {
            ObjId max;
            ObjId min;
            if (!ctx.isEOF() || !complete) {
                throw new ParseException(ctx, "invalid object ID");
            }
            char[] paramChars = param.toCharArray();
            char[] idChars = new char[16];
            System.arraycopy(paramChars, 0, idChars, 0, paramChars.length);
            Arrays.fill(idChars, paramChars.length, idChars.length, '0');
            String minString = new String(idChars);
            try {
                min = new ObjId(minString);
            }
            catch (IllegalArgumentException e2) {
                if (!minString.startsWith("00")) {
                    throw new ParseException(ctx, "invalid object ID");
                }
                min = null;
            }
            Arrays.fill(idChars, paramChars.length, idChars.length, 'f');
            try {
                max = new ObjId(new String(idChars));
            }
            catch (IllegalArgumentException e3) {
                max = null;
            }
            CompletionFinder finder = new CompletionFinder(min, max);
            session.performParseSessionAction(finder);
            throw new ParseException(ctx, "invalid object ID").addCompletions(ParseUtil.complete(finder.getCompletions(), param));
        }
    }

    private static class CompletionFinder
    implements ParseSession.Action,
    Session.RetryableAction {
        private final ArrayList<String> completions = new ArrayList();
        private final ObjId min;
        private final ObjId max;

        CompletionFinder(ObjId min, ObjId max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public void run(ParseSession session) throws Exception {
            Transaction tx = session.getTransaction();
            ArrayList<NavigableSet<ObjId>> idSets = new ArrayList<NavigableSet<ObjId>>();
            this.completions.clear();
            for (Schema schema : tx.getSchemas().getVersions().values()) {
                for (ObjType objType : schema.getObjTypes().values()) {
                    int storageId = objType.getStorageId();
                    if (this.min != null && storageId < this.min.getStorageId() || this.max != null && storageId > this.max.getStorageId()) continue;
                    NavigableSet<ObjId> idSet = tx.getAll(storageId);
                    if (this.min != null) {
                        try {
                            idSet = idSet.tailSet(this.min, true);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if (this.max != null) {
                        try {
                            idSet = idSet.headSet(this.max, true);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    idSets.add(idSet);
                }
            }
            boolean count = false;
            if (!idSets.isEmpty()) {
                for (ObjId id : Iterables.limit((Iterable)NavigableSets.union(idSets), (int)100)) {
                    this.completions.add(id.toString());
                }
            }
        }

        public List<String> getCompletions() {
            return this.completions;
        }
    }
}

