/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse;

import org.jsimpledb.core.DeletedObjectException;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.parse.ParseSession;

public class ObjInfo {
    private final ObjId id;
    private final Schema schema;
    private final ObjType type;

    public ObjInfo(Transaction tx, ObjId id) {
        this.id = id;
        this.schema = tx.getSchemas().getVersion(tx.getSchemaVersion(id));
        this.type = this.schema.getObjType(id.getStorageId());
    }

    public ObjId getObjId() {
        return this.id;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public ObjType getObjType() {
        return this.type;
    }

    public String toString() {
        return this.id + " type " + this.type.getName() + "#" + this.type.getStorageId() + " version " + this.schema.getVersionNumber();
    }

    public static ObjInfo getObjInfo(ParseSession session, ObjId id) {
        try {
            return new ObjInfo(session.getTransaction(), id);
        }
        catch (DeletedObjectException e) {
            return null;
        }
    }
}

