/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse;

import com.google.common.reflect.TypeToken;
import java.util.regex.Matcher;
import org.jsimpledb.Session;
import org.jsimpledb.core.Database;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.UnknownTypeException;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.schema.NameIndex;
import org.jsimpledb.schema.SchemaObjectType;
import org.jsimpledb.util.ParseContext;

public class ObjTypeParser
implements Parser<ObjType> {
    @Override
    public ObjType parse(ParseSession session, ParseContext ctx, boolean complete) {
        ParserAction parserAction = new ParserAction(ctx, complete);
        session.performParseSessionAction(parserAction);
        ObjType result = parserAction.getResult();
        Exception exception = parserAction.getException();
        if (exception != null || result == null) {
            throw exception instanceof ParseException ? (ParseException)exception : new ParseException(ctx, (Throwable)exception);
        }
        return result;
    }

    private ObjType parseInTransaction(ParseSession session, ParseContext ctx, boolean complete) {
        Transaction tx = session.getTransaction();
        Database db = session.getDatabase();
        int startIndex = ctx.getIndex();
        try {
            int storageId = (Integer)db.getFieldTypeRegistry().getFieldType(TypeToken.of(Integer.TYPE)).fromParseableString(ctx);
            return tx.getSchema().getObjType(storageId);
        }
        catch (IllegalArgumentException | UnknownTypeException storageId) {
            NameIndex nameIndex;
            Schema schema;
            Matcher matcher;
            ctx.setIndex(startIndex);
            try {
                matcher = ctx.matchPrefix("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)(#([0-9]+))?");
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(ctx, "invalid object type").addCompletions(session.getNameIndex().getSchemaObjectTypeNames());
            }
            String typeName = matcher.group(1);
            String versionString = matcher.group(3);
            if (versionString != null) {
                try {
                    schema = tx.getSchemas().getVersion(Integer.parseInt(versionString));
                }
                catch (IllegalArgumentException e) {
                    ctx.setIndex(startIndex);
                    throw new ParseException(ctx, "invalid object type schema version `" + versionString + "'");
                }
                nameIndex = new NameIndex(schema.getSchemaModel());
            } else {
                schema = tx.getSchema();
                nameIndex = session.getNameIndex();
            }
            SchemaObjectType schemaObjectType = nameIndex.getSchemaObjectType(typeName);
            if (schemaObjectType == null) {
                throw new ParseException(ctx, "unknown object type `" + typeName + "'").addCompletions(ParseUtil.complete(nameIndex.getSchemaObjectTypeNames(), typeName));
            }
            return schema.getObjType(schemaObjectType.getStorageId());
        }
    }

    private class ParserAction
    implements ParseSession.Action,
    Session.RetryableAction {
        private final ParseContext ctx;
        private final boolean complete;
        private ObjType result;
        private Exception exception;

        ParserAction(ParseContext ctx, boolean complete) {
            this.ctx = ctx;
            this.complete = complete;
        }

        @Override
        public void run(ParseSession session) throws Exception {
            try {
                this.result = ObjTypeParser.this.parseInTransaction(session, this.ctx, this.complete);
            }
            catch (ParseException e) {
                this.exception = e;
            }
        }

        public ObjType getResult() {
            return this.result;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

