/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse;

import org.jsimpledb.parse.ParseException;
import org.jsimpledb.util.ParseContext;

public class SpaceParser {
    private final boolean required;
    private final boolean weak;

    public SpaceParser() {
        this(false);
    }

    public SpaceParser(boolean required) {
        this(required, true);
    }

    public SpaceParser(boolean required, boolean weak) {
        this.required = required;
        this.weak = weak;
    }

    public void parse(ParseContext ctx, boolean complete) {
        if (ctx.tryPattern("\\s+") != null) {
            return;
        }
        if (this.required) {
            throw new ParseException(ctx).addCompletion(" ");
        }
        if (!complete) {
            return;
        }
        if (ctx.getIndex() != 0 && Character.isWhitespace(ctx.getOriginalInput().charAt(ctx.getIndex() - 1))) {
            return;
        }
        if (this.weak && !ctx.isEOF()) {
            return;
        }
        throw new ParseException(ctx).addCompletion(" ");
    }
}

