/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.util.ParseContext;

public class WordParser
implements Parser<String> {
    private final Collection<String> words;
    private final String description;

    public WordParser(Collection<String> words, String description) {
        Preconditions.checkArgument((words != null ? 1 : 0) != 0, (Object)"null words");
        Preconditions.checkArgument((description != null ? 1 : 0) != 0, (Object)"null description");
        this.words = new TreeSet<String>(words);
        this.description = description;
    }

    public WordParser(String description) {
        Preconditions.checkArgument((description != null ? 1 : 0) != 0, (Object)"null description");
        this.words = null;
        this.description = description;
    }

    protected Collection<String> getWords() {
        return this.words;
    }

    @Override
    public String parse(ParseSession session, ParseContext ctx, boolean complete) {
        Matcher matcher = ctx.tryPattern("[^\\s;]*");
        if (matcher == null) {
            throw new ParseException(ctx);
        }
        String word = matcher.group();
        Collection<String> validWords = this.getWords();
        if (validWords != null) {
            TreeSet<String> sortedWords = new TreeSet<String>(validWords);
            if (!sortedWords.contains(word)) {
                throw new ParseException(ctx, "unknown " + this.description + " `" + word + "'").addCompletions(ParseUtil.complete(sortedWords, word));
            }
        } else if (word.length() == 0) {
            throw new ParseException(ctx, "missing " + this.description);
        }
        return word;
    }
}

