/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NavigableSet;
import java.util.Set;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.LValue;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.util.NavigableSets;

public abstract class AbstractValue
implements Value {
    protected AbstractValue() {
    }

    @Override
    public Class<?> getType(ParseSession session) {
        return Object.class;
    }

    @Override
    public Object checkNotNull(ParseSession session, String operation) {
        Object value = this.get(session);
        if (value == null) {
            throw new EvalException("invalid " + operation + " operation on null value");
        }
        return value;
    }

    @Override
    public boolean checkBoolean(ParseSession session, String operation) {
        return this.checkType(session, operation, Boolean.class);
    }

    @Override
    public Number checkNumeric(ParseSession session, String operation) {
        return AbstractValue.checkNumeric(session, this.get(session), operation);
    }

    @Override
    public int checkIntegral(ParseSession session, String operation) {
        Object value = this.checkNotNull(session, operation);
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (!(value instanceof Byte || value instanceof Short || value instanceof Integer)) {
            throw new EvalException("invalid " + operation + " operation on " + AbstractValue.describeType(value, "non-integral"));
        }
        return ((Number)value).intValue();
    }

    @Override
    public <T> T checkType(ParseSession session, String operation, Class<T> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        Object value = this.checkNotNull(session, operation);
        if (!type.isInstance(value)) {
            throw new EvalException("invalid " + operation + " operation on " + AbstractValue.describeType(value, "non-" + type.getSimpleName()));
        }
        return type.cast(value);
    }

    @Override
    public Value xxcrement(ParseSession session, String operation, boolean increment) {
        Object num;
        int amount = increment ? 1 : -1;
        LValue thisLValue = this.asLValue(operation);
        Object value = this.get(session);
        Object object = num = value instanceof Character ? value : AbstractValue.checkNumeric(session, value, operation);
        if (num instanceof Byte) {
            num = (byte)((Byte)num + (byte)amount);
        } else if (num instanceof Character) {
            num = Character.valueOf((char)(((Character)num).charValue() + (char)amount));
        } else if (num instanceof Short) {
            num = (short)((Short)num + (short)amount);
        } else if (num instanceof Integer) {
            num = (Integer)num + amount;
        } else if (num instanceof Float) {
            num = Float.valueOf(((Float)num).floatValue() + (float)amount);
        } else if (num instanceof Long) {
            num = (Long)num + (long)amount;
        } else if (num instanceof Double) {
            num = (Double)num + (double)amount;
        } else if (num instanceof BigInteger) {
            num = ((BigInteger)num).add(increment ? BigInteger.ONE : BigInteger.ONE.negate());
        } else if (num instanceof BigDecimal) {
            num = ((BigDecimal)num).add(increment ? BigDecimal.ONE : BigDecimal.ONE.negate());
        } else {
            throw new EvalException("invalid " + operation + " operation on " + AbstractValue.describeType(num, new String[0]));
        }
        ConstValue result = new ConstValue(num);
        thisLValue.set(session, result);
        return result;
    }

    @Override
    public Value negate(ParseSession session) {
        Number num = AbstractValue.promoteNumeric(session, this.get(session), "negate", new Object[0]);
        if (num instanceof BigDecimal) {
            return new ConstValue(((BigDecimal)num).negate());
        }
        if (num instanceof Double) {
            return new ConstValue(-((Double)num).doubleValue());
        }
        if (num instanceof Float) {
            return new ConstValue(Float.valueOf(-((Float)num).floatValue()));
        }
        if (num instanceof BigInteger) {
            return new ConstValue(((BigInteger)num).negate());
        }
        if (num instanceof Long) {
            return new ConstValue(-((Long)num).longValue());
        }
        if (num instanceof Integer) {
            return new ConstValue(-((Integer)num).intValue());
        }
        throw new EvalException("invalid negate operation on " + AbstractValue.describeType(num, new String[0]));
    }

    @Override
    public Value invert(ParseSession session) {
        Number num = AbstractValue.promoteNumeric(session, this.get(session), "invert", new Object[0]);
        if (num instanceof Integer) {
            return new ConstValue(~((Integer)num).intValue());
        }
        if (num instanceof Long) {
            return new ConstValue((Long)num ^ 0xFFFFFFFFFFFFFFFFL);
        }
        throw new EvalException("invalid invert operation on " + AbstractValue.describeType(num, new String[0]));
    }

    @Override
    public Value multiply(ParseSession session, Value that) {
        Object thisValue = this.checkNotNull(session, "multiply");
        Object thatValue = that.checkNotNull(session, "multiply");
        Number lnum = AbstractValue.promoteNumeric(session, thisValue, "multiply", thatValue);
        Number rnum = AbstractValue.promoteNumeric(session, thatValue, "multiply", thisValue);
        if (lnum instanceof BigDecimal) {
            return new ConstValue(((BigDecimal)lnum).multiply((BigDecimal)rnum));
        }
        if (lnum instanceof Double) {
            return new ConstValue((Double)lnum * (Double)rnum);
        }
        if (lnum instanceof Float) {
            return new ConstValue(Float.valueOf(((Float)lnum).floatValue() * ((Float)rnum).floatValue()));
        }
        if (lnum instanceof BigInteger) {
            return new ConstValue(((BigInteger)lnum).multiply((BigInteger)rnum));
        }
        if (lnum instanceof Long) {
            return new ConstValue((Long)lnum * (Long)rnum);
        }
        if (lnum instanceof Integer) {
            return new ConstValue((Integer)lnum * (Integer)rnum);
        }
        throw new EvalException("invalid multiply operation on values of type " + lnum.getClass().getName() + " and " + rnum.getClass().getName());
    }

    @Override
    public Value divide(ParseSession session, Value that) {
        Object thisValue = this.checkNotNull(session, "divide");
        Object thatValue = that.checkNotNull(session, "divide");
        Number lnum = AbstractValue.promoteNumeric(session, thisValue, "divide", thatValue);
        Number rnum = AbstractValue.promoteNumeric(session, thatValue, "divide", thisValue);
        if (lnum instanceof BigDecimal) {
            return new ConstValue(((BigDecimal)lnum).divide((BigDecimal)rnum));
        }
        if (lnum instanceof Double) {
            return new ConstValue((Double)lnum / (Double)rnum);
        }
        if (lnum instanceof Float) {
            return new ConstValue(Float.valueOf(((Float)lnum).floatValue() / ((Float)rnum).floatValue()));
        }
        if (lnum instanceof BigInteger) {
            return new ConstValue(((BigInteger)lnum).divide((BigInteger)rnum));
        }
        if (lnum instanceof Long) {
            return new ConstValue((Long)lnum / (Long)rnum);
        }
        if (lnum instanceof Integer) {
            return new ConstValue((Integer)lnum / (Integer)rnum);
        }
        throw new EvalException("invalid divide operation on values of type " + lnum.getClass().getName() + " and " + rnum.getClass().getName());
    }

    @Override
    public Value mod(ParseSession session, Value that) {
        Object thisValue = this.checkNotNull(session, "modulo");
        Object thatValue = that.checkNotNull(session, "modulo");
        Number lnum = AbstractValue.promoteNumeric(session, thisValue, "modulo", thatValue);
        Number rnum = AbstractValue.promoteNumeric(session, thatValue, "modulo", thisValue);
        if (lnum instanceof Double) {
            return new ConstValue((Double)lnum % (Double)rnum);
        }
        if (lnum instanceof Float) {
            return new ConstValue(Float.valueOf(((Float)lnum).floatValue() % ((Float)rnum).floatValue()));
        }
        if (lnum instanceof BigInteger) {
            return new ConstValue(((BigInteger)lnum).mod((BigInteger)rnum));
        }
        if (lnum instanceof Long) {
            return new ConstValue((Long)lnum % (Long)rnum);
        }
        if (lnum instanceof Integer) {
            return new ConstValue((Integer)lnum % (Integer)rnum);
        }
        throw new EvalException("invalid modulo operation on values of type " + lnum.getClass().getName() + " and " + rnum.getClass().getName());
    }

    @Override
    public Value add(ParseSession session, Value that) {
        Object thisValue = this.get(session);
        Object thatValue = that.get(session);
        if (thisValue == null || thatValue == null || thisValue instanceof String || thatValue instanceof String) {
            return new ConstValue(String.valueOf(thisValue) + String.valueOf(thatValue));
        }
        Number lnum = AbstractValue.promoteNumeric(session, thisValue, "add", thatValue);
        Number rnum = AbstractValue.promoteNumeric(session, thatValue, "add", thisValue);
        if (lnum instanceof BigDecimal) {
            return new ConstValue(((BigDecimal)lnum).add((BigDecimal)rnum));
        }
        if (lnum instanceof Double) {
            return new ConstValue((Double)lnum + (Double)rnum);
        }
        if (lnum instanceof Float) {
            return new ConstValue(Float.valueOf(((Float)lnum).floatValue() + ((Float)rnum).floatValue()));
        }
        if (lnum instanceof BigInteger) {
            return new ConstValue(((BigInteger)lnum).add((BigInteger)rnum));
        }
        if (lnum instanceof Long) {
            return new ConstValue((Long)lnum + (Long)rnum);
        }
        if (lnum instanceof Integer) {
            return new ConstValue((Integer)lnum + (Integer)rnum);
        }
        throw new EvalException("invalid add operation on values of type " + lnum.getClass().getName() + " and " + rnum.getClass().getName());
    }

    @Override
    public Value subtract(ParseSession session, Value that) {
        Object thisValue = this.checkNotNull(session, "subtract");
        Object thatValue = that.checkNotNull(session, "subtract");
        if (thisValue instanceof NavigableSet && thatValue instanceof NavigableSet && (((NavigableSet)thisValue).comparator() != null ? ((NavigableSet)thisValue).comparator().equals(((NavigableSet)thatValue).comparator()) : ((NavigableSet)thatValue).comparator() == null)) {
            return new ConstValue(NavigableSets.difference((NavigableSet)((NavigableSet)thisValue), (NavigableSet)((NavigableSet)thatValue)));
        }
        if (thisValue instanceof Set && thatValue instanceof Set) {
            return new ConstValue(Sets.difference((Set)((Set)thisValue), (Set)((Set)thatValue)));
        }
        Number lnum = AbstractValue.promoteNumeric(session, thisValue, "subtract", thatValue);
        Number rnum = AbstractValue.promoteNumeric(session, thatValue, "subtract", thisValue);
        if (lnum instanceof BigDecimal) {
            return new ConstValue(((BigDecimal)lnum).subtract((BigDecimal)rnum));
        }
        if (lnum instanceof Double) {
            return new ConstValue((Double)lnum - (Double)rnum);
        }
        if (lnum instanceof Float) {
            return new ConstValue(Float.valueOf(((Float)lnum).floatValue() - ((Float)rnum).floatValue()));
        }
        if (lnum instanceof BigInteger) {
            return new ConstValue(((BigInteger)lnum).subtract((BigInteger)rnum));
        }
        if (lnum instanceof Long) {
            return new ConstValue((Long)lnum - (Long)rnum);
        }
        if (lnum instanceof Integer) {
            return new ConstValue((Integer)lnum - (Integer)rnum);
        }
        throw new EvalException("invalid subtract operation on values of type " + lnum.getClass().getName() + " and " + rnum.getClass().getName());
    }

    @Override
    public Value lshift(ParseSession session, Value arg) {
        Object thisValue = this.checkNotNull(session, "left shift");
        Object thatValue = arg.checkNotNull(session, "left shift");
        Number target = AbstractValue.promoteNumeric(session, thisValue, "left shift", new Object[0]);
        Number shift = AbstractValue.promoteNumeric(session, thatValue, "left shift", new Object[0]);
        if (!(target instanceof Integer) && !(target instanceof Long)) {
            throw new EvalException("invalid left shift target " + AbstractValue.describeType(target, new String[0]));
        }
        if (!(shift instanceof Integer) && !(shift instanceof Long)) {
            throw new EvalException("invalid left shift " + AbstractValue.describeType(shift, new String[0]));
        }
        if (target instanceof Long) {
            return new ConstValue((Long)target << (shift.intValue() & 0x3F));
        }
        if (target instanceof Integer) {
            return new ConstValue((Integer)target << (shift.intValue() & 0x1F));
        }
        throw new EvalException("invalid left shift operation on " + AbstractValue.describeType(target, new String[0]) + " and " + AbstractValue.describeType(shift, new String[0]));
    }

    @Override
    public Value rshift(ParseSession session, Value arg) {
        Object thisValue = this.checkNotNull(session, "right shift");
        Object thatValue = arg.checkNotNull(session, "right shift");
        Number target = AbstractValue.promoteNumeric(session, thisValue, "right shift", new Object[0]);
        Number shift = AbstractValue.promoteNumeric(session, thatValue, "right shift", new Object[0]);
        if (!(target instanceof Integer) && !(target instanceof Long)) {
            throw new EvalException("invalid right shift target " + AbstractValue.describeType(target, new String[0]));
        }
        if (!(shift instanceof Integer) && !(shift instanceof Long)) {
            throw new EvalException("invalid right shift " + AbstractValue.describeType(shift, new String[0]));
        }
        if (target instanceof Long) {
            return new ConstValue((Long)target >> (shift.intValue() & 0x3F));
        }
        if (target instanceof Integer) {
            return new ConstValue((Integer)target >> (shift.intValue() & 0x1F));
        }
        throw new EvalException("invalid right shift operation on " + AbstractValue.describeType(target, new String[0]) + " and " + AbstractValue.describeType(shift, new String[0]));
    }

    @Override
    public Value urshift(ParseSession session, Value arg) {
        Object thisValue = this.checkNotNull(session, "unsigned right shift");
        Object thatValue = arg.checkNotNull(session, "unsigned right shift");
        Number target = AbstractValue.promoteNumeric(session, thisValue, "unsigned right shift", new Object[0]);
        Number shift = AbstractValue.promoteNumeric(session, thatValue, "unsigned right shift", new Object[0]);
        if (!(target instanceof Integer) && !(target instanceof Long)) {
            throw new EvalException("invalid unsigned right shift target " + AbstractValue.describeType(target, new String[0]));
        }
        if (!(shift instanceof Integer) && !(shift instanceof Long)) {
            throw new EvalException("invalid unsigned right shift " + AbstractValue.describeType(shift, new String[0]));
        }
        if (target instanceof Long) {
            return new ConstValue((Long)target >>> (shift.intValue() & 0x3F));
        }
        if (target instanceof Integer) {
            return new ConstValue((Integer)target >>> (shift.intValue() & 0x1F));
        }
        throw new EvalException("invalid unsigned right shift operation on " + AbstractValue.describeType(target, new String[0]) + " and " + AbstractValue.describeType(shift, new String[0]));
    }

    @Override
    public Value and(ParseSession session, Value that) {
        Object thisValue = this.checkNotNull(session, "`and'");
        Object thatValue = that.checkNotNull(session, "`and'");
        if (thisValue instanceof Boolean && thatValue instanceof Boolean) {
            return new ConstValue((Boolean)thisValue & (Boolean)thatValue);
        }
        if (thisValue instanceof NavigableSet && thatValue instanceof NavigableSet && (((NavigableSet)thisValue).comparator() != null ? ((NavigableSet)thisValue).comparator().equals(((NavigableSet)thatValue).comparator()) : ((NavigableSet)thatValue).comparator() == null)) {
            return new ConstValue(NavigableSets.intersection((NavigableSet[])new NavigableSet[]{(NavigableSet)thisValue, (NavigableSet)thatValue}));
        }
        if (thisValue instanceof Set && thatValue instanceof Set) {
            return new ConstValue(Sets.intersection((Set)((Set)thisValue), (Set)((Set)thatValue)));
        }
        Number lnum = AbstractValue.promoteNumeric(session, thisValue, "`and'", thatValue);
        Number rnum = AbstractValue.promoteNumeric(session, thatValue, "`and'", thisValue);
        if (!(lnum instanceof Integer || lnum instanceof Long || lnum instanceof BigInteger)) {
            throw new EvalException("invalid `and' operation on " + AbstractValue.describeType(lnum, new String[0]));
        }
        if (lnum instanceof BigInteger) {
            return new ConstValue(((BigInteger)lnum).and((BigInteger)rnum));
        }
        if (lnum instanceof Long) {
            return new ConstValue((Long)lnum & (Long)rnum);
        }
        return new ConstValue((Integer)lnum & (Integer)rnum);
    }

    @Override
    public Value or(ParseSession session, Value that) {
        Object thisValue = this.checkNotNull(session, "`or'");
        Object thatValue = that.checkNotNull(session, "`or'");
        if (thisValue instanceof Boolean && thatValue instanceof Boolean) {
            return new ConstValue((Boolean)thisValue | (Boolean)thatValue);
        }
        if (thisValue instanceof NavigableSet && thatValue instanceof NavigableSet && (((NavigableSet)thisValue).comparator() != null ? ((NavigableSet)thisValue).comparator().equals(((NavigableSet)thatValue).comparator()) : ((NavigableSet)thatValue).comparator() == null)) {
            return new ConstValue(NavigableSets.union((NavigableSet[])new NavigableSet[]{(NavigableSet)thisValue, (NavigableSet)thatValue}));
        }
        if (thisValue instanceof Set && thatValue instanceof Set) {
            return new ConstValue(Sets.union((Set)((Set)thisValue), (Set)((Set)thatValue)));
        }
        Number lnum = AbstractValue.promoteNumeric(session, thisValue, "`or'", thatValue);
        Number rnum = AbstractValue.promoteNumeric(session, thatValue, "`or'", thisValue);
        if (!(lnum instanceof Integer || lnum instanceof Long || lnum instanceof BigInteger)) {
            throw new EvalException("invalid `or' operation on " + AbstractValue.describeType(lnum, new String[0]));
        }
        if (lnum instanceof BigInteger) {
            return new ConstValue(((BigInteger)lnum).or((BigInteger)rnum));
        }
        if (lnum instanceof Long) {
            return new ConstValue((Long)lnum | (Long)rnum);
        }
        return new ConstValue((Integer)lnum | (Integer)rnum);
    }

    @Override
    public Value xor(ParseSession session, Value that) {
        Object thisValue = this.checkNotNull(session, "exclusive `or'");
        Object thatValue = that.checkNotNull(session, "exclusive `or'");
        if (thisValue instanceof Boolean && thatValue instanceof Boolean) {
            return new ConstValue((Boolean)thisValue ^ (Boolean)thatValue);
        }
        if (thisValue instanceof NavigableSet && thatValue instanceof NavigableSet && (((NavigableSet)thisValue).comparator() != null ? ((NavigableSet)thisValue).comparator().equals(((NavigableSet)thatValue).comparator()) : ((NavigableSet)thatValue).comparator() == null)) {
            return new ConstValue(NavigableSets.symmetricDifference((NavigableSet)((NavigableSet)thisValue), (NavigableSet)((NavigableSet)thatValue)));
        }
        if (thisValue instanceof Set && thatValue instanceof Set) {
            return new ConstValue(Sets.symmetricDifference((Set)((Set)thisValue), (Set)((Set)thatValue)));
        }
        Number lnum = AbstractValue.promoteNumeric(session, thisValue, "exclusive `or'", thatValue);
        Number rnum = AbstractValue.promoteNumeric(session, thatValue, "exclusive `or'", thisValue);
        if (!(lnum instanceof Integer || lnum instanceof Long || lnum instanceof BigInteger)) {
            throw new EvalException("invalid exclusive `or' operation on " + AbstractValue.describeType(lnum, new String[0]));
        }
        if (lnum instanceof BigInteger) {
            return new ConstValue(((BigInteger)lnum).xor((BigInteger)rnum));
        }
        if (lnum instanceof Long) {
            return new ConstValue((Long)lnum ^ (Long)rnum);
        }
        return new ConstValue((Integer)lnum ^ (Integer)rnum);
    }

    @Override
    public Value compare(ParseSession session, Value that, int mask) {
        Object thatValue;
        Object thisValue;
        block6: {
            block7: {
                int result;
                block9: {
                    Number rnum;
                    Number lnum;
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        thisValue = this.checkNotNull(session, "comparison");
                                        thatValue = that.checkNotNull(session, "comparison");
                                        if (!(thisValue instanceof Number) || !(thatValue instanceof Number)) break block7;
                                        lnum = AbstractValue.promoteNumeric(session, thisValue, "comparison", thatValue);
                                        rnum = AbstractValue.promoteNumeric(session, thatValue, "comparison", thisValue);
                                        if (!(lnum instanceof BigDecimal)) break block8;
                                        result = ((BigDecimal)lnum).compareTo((BigDecimal)rnum);
                                        break block9;
                                    }
                                    if (!(lnum instanceof Double)) break block10;
                                    result = Double.compare((Double)lnum, (Double)rnum);
                                    break block9;
                                }
                                if (!(lnum instanceof Float)) break block11;
                                result = Float.compare(((Float)lnum).floatValue(), ((Float)rnum).floatValue());
                                break block9;
                            }
                            if (!(lnum instanceof BigInteger)) break block12;
                            result = ((BigInteger)lnum).compareTo((BigInteger)rnum);
                            break block9;
                        }
                        if (!(lnum instanceof Long)) break block13;
                        result = Long.compare((Long)lnum, (Long)rnum);
                        break block9;
                    }
                    if (!(lnum instanceof Integer)) break block7;
                    result = Integer.compare((Integer)lnum, (Integer)rnum);
                }
                result = result < 0 ? 1 : (result > 0 ? 2 : 4);
                return new ConstValue((result & mask) != 0);
            }
            if (thisValue instanceof Comparable && thatValue instanceof Comparable) {
                int result;
                try {
                    result = ((Comparable)thisValue).compareTo(thatValue);
                }
                catch (ClassCastException e) {
                    break block6;
                }
                result = result < 0 ? 1 : (result > 0 ? 2 : 4);
                return new ConstValue((result & mask) != 0);
            }
        }
        throw new EvalException("invalid comparison operation between " + AbstractValue.describeType(thisValue, new String[0]) + " and " + AbstractValue.describeType(thatValue, new String[0]));
    }

    @Override
    public LValue asLValue(String operation) {
        try {
            return (LValue)((Object)this);
        }
        catch (ClassCastException e) {
            throw new EvalException("invalid " + operation + " operation on non-assignable value");
        }
    }

    static Number promoteNumeric(ParseSession session, Object obj, String operation, Object ... args) {
        Number num;
        Number number = num = obj instanceof Character ? (Number)Integer.valueOf(((Character)obj).charValue()) : (Number)AbstractValue.checkNumeric(session, obj, operation);
        if (num instanceof Byte || num instanceof Short) {
            num = num.intValue();
        }
        if (args.length > 0) {
            ArrayList<Number> nums = new ArrayList<Number>(1 + args.length);
            nums.add(num);
            nums.addAll(Lists.transform(Arrays.asList(args), value -> AbstractValue.promoteNumeric(session, value, operation, new Object[0])));
            num = nums.stream().anyMatch(n -> n instanceof BigDecimal) ? AbstractValue.toBigDecimal(num) : (nums.stream().anyMatch(n -> n instanceof Double) ? (Number)num.doubleValue() : (Number)(nums.stream().anyMatch(n -> n instanceof Float) ? (Number)Float.valueOf(num.floatValue()) : (Number)(nums.stream().anyMatch(n -> n instanceof BigInteger) ? AbstractValue.toBigInteger(num) : (nums.stream().anyMatch(n -> n instanceof Long) ? (Number)num.longValue() : (Number)num.intValue()))));
        }
        return num;
    }

    static Number checkNumeric(ParseSession session, Object obj, String operation) {
        if (!(obj instanceof Number)) {
            throw new EvalException("invalid " + operation + " operation on " + AbstractValue.describeType(obj, "non-numeric"));
        }
        return (Number)obj;
    }

    static BigDecimal toBigDecimal(Number num) {
        if (num instanceof BigDecimal) {
            return (BigDecimal)num;
        }
        if (num instanceof BigInteger) {
            return new BigDecimal((BigInteger)num);
        }
        if (num instanceof Double || num instanceof Float) {
            return new BigDecimal(num.doubleValue());
        }
        if (num instanceof Long || num instanceof Integer || num instanceof Short || num instanceof Byte) {
            return new BigDecimal(num.longValue());
        }
        throw new EvalException("can't convert " + AbstractValue.describeType(num, new String[0]) + " to BigDecimal");
    }

    static BigInteger toBigInteger(Number num) {
        return AbstractValue.toBigDecimal(num).toBigInteger();
    }

    static String describeType(Object obj, String ... prefix) {
        if (obj == null) {
            return "null value";
        }
        return (prefix.length > 0 ? prefix[0] + " " : "") + "value of type " + obj.getClass().getName();
    }
}

