/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.expr.BinaryExprParser;
import org.jsimpledb.parse.expr.ConditionalParser;
import org.jsimpledb.parse.expr.LValue;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Op;
import org.jsimpledb.parse.expr.Value;

public class AssignmentExprParser
extends BinaryExprParser {
    public static final AssignmentExprParser INSTANCE = new AssignmentExprParser();

    public AssignmentExprParser() {
        super((Parser<? extends Node>)ConditionalParser.INSTANCE, false, Op.EQUALS, Op.PLUS_EQUALS, Op.MINUS_EQUALS, Op.MULTIPLY_EQUALS, Op.DIVIDE_EQUALS, Op.MODULO_EQUALS, Op.AND_EQUALS, Op.XOR_EQUALS, Op.OR_EQUALS, Op.LSHIFT_EQUALS, Op.RSHIFT_EQUALS, Op.URSHIFT_EQUALS);
    }

    @Override
    protected Node createNode(final Op op, final Node lhs, final Node rhs) {
        return new Node(){

            @Override
            public Value evaluate(ParseSession session) {
                LValue lvalue = lhs.evaluate(session).asLValue("assignment");
                Value value = rhs.evaluate(session);
                if (op != Op.EQUALS) {
                    value = Op.forSymbol(op.getSymbol().replaceAll("=", "")).apply(session, (Value)lvalue, value);
                }
                lvalue.set(session, value);
                return value;
            }

            @Override
            public Class<?> getType(ParseSession session) {
                return lhs.getType(session);
            }
        };
    }
}

