/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.SpaceParser;
import org.jsimpledb.parse.expr.ClassNode;
import org.jsimpledb.parse.expr.ConstNode;
import org.jsimpledb.parse.expr.ConstructorInvokeNode;
import org.jsimpledb.parse.expr.EmptyArrayNode;
import org.jsimpledb.parse.expr.ExprParser;
import org.jsimpledb.parse.expr.LiteralArrayNode;
import org.jsimpledb.parse.expr.LiteralExprParser;
import org.jsimpledb.parse.expr.MethodInvokeNode;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.StaticFieldValue;
import org.jsimpledb.parse.expr.UnboundMethodReferenceNode;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.parse.func.Function;
import org.jsimpledb.util.ParseContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class AtomExprParser
implements Parser<Node> {
    public static final AtomExprParser INSTANCE = new AtomExprParser();
    private final SpaceParser spaceParser = new SpaceParser();

    @Override
    public Node parse(ParseSession session, ParseContext ctx, boolean complete) {
        int start = ctx.getIndex();
        if (ctx.tryLiteral("(")) {
            this.spaceParser.parse(ctx, complete);
            Node node = ExprParser.INSTANCE.parse(session, ctx, complete);
            this.spaceParser.parse(ctx, complete);
            if (!ctx.tryLiteral(")")) {
                throw new ParseException(ctx).addCompletion(") ");
            }
            return node;
        }
        try {
            return LiteralExprParser.INSTANCE.parse(session, ctx, complete);
        }
        catch (ParseException e) {
            Matcher staticMatcher;
            Matcher nameDotMatcher;
            Matcher methodMatcher;
            ctx.setIndex(start);
            if (ctx.tryPattern("new(?!\\p{javaJavaIdentifierPart})") != null) {
                ArrayList<Node> dimensions;
                ClassNode classNode;
                block43: {
                    new SpaceParser(true).parse(ctx, complete);
                    String className = ctx.matchPrefix("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*(?:\\.\\s*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*").group().replaceAll("\\s+", "");
                    classNode = ClassNode.parse(ctx, className, true);
                    if (complete && ctx.isEOF()) {
                        try {
                            session.resolveClass(className, true);
                        }
                        catch (IllegalArgumentException e2) {
                            throw new ParseException(ctx).addCompletions(AtomExprParser.getClassNameCompletions(session, className));
                        }
                    }
                    if (className.equals("void")) {
                        throw new ParseException(ctx, "illegal instantiation of void");
                    }
                    dimensions = new ArrayList<Node>();
                    boolean sawNull = false;
                    while (true) {
                        ctx.skipWhitespace();
                        if (!ctx.tryLiteral("[")) break block43;
                        ctx.skipWhitespace();
                        if (ctx.tryLiteral("]")) {
                            dimensions.add(null);
                            sawNull = true;
                            continue;
                        }
                        if (!sawNull) {
                            dimensions.add(ExprParser.INSTANCE.parse(session, ctx, complete));
                            ctx.skipWhitespace();
                        }
                        if (!ctx.tryLiteral("]")) break;
                    }
                    throw new ParseException(ctx, "expected `]'").addCompletion("]");
                }
                int numDimensions = dimensions.size();
                if (numDimensions == 0) {
                    if (!ctx.tryLiteral("(")) {
                        throw new ParseException(ctx, "expected `('").addCompletion("(");
                    }
                    ctx.skipWhitespace();
                    List<Node> paramNodes = AtomExprParser.parseParams(session, ctx, complete);
                    return new ConstructorInvokeNode(classNode, paramNodes);
                }
                if (numDimensions > 255) {
                    throw new ParseException(ctx, "too many array dimensions (" + numDimensions + " > 255)");
                }
                return dimensions.get(0) != null ? new EmptyArrayNode(classNode, dimensions) : new LiteralArrayNode(classNode, numDimensions, LiteralArrayNode.parseArrayLiteral(session, ctx, complete, numDimensions));
            }
            ctx.setIndex(start);
            Matcher functionMatcher = ctx.tryPattern("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\s*\\(");
            if (functionMatcher != null) {
                String functionName = functionMatcher.group(1);
                final Function function = (Function)session.getFunctions().get(functionName);
                if (function == null) {
                    throw new ParseException(ctx, "unknown function `" + functionName + "()'").addCompletions(ParseUtil.complete(session.getFunctions().keySet(), functionName));
                }
                ctx.skipWhitespace();
                final Object params = function.parseParams(session, ctx, complete);
                return new Node(){

                    @Override
                    public Value evaluate(ParseSession session) {
                        return function.apply(session, params);
                    }

                    @Override
                    public Class<?> getType(ParseSession session) {
                        return Object.class;
                    }
                };
            }
            Parser<? extends Node> identifierParser = session.getIdentifierParser();
            if (identifierParser != null) {
                try {
                    Node node = identifierParser.parse(session, ctx, complete);
                    ctx.skipWhitespace();
                    return node;
                }
                catch (ParseException e3) {
                    if (complete && ctx.isEOF()) {
                        throw e3;
                    }
                    ctx.setIndex(start);
                }
            }
            if ((methodMatcher = ctx.tryPattern("((?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*(?:\\.\\s*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*)\\s*(?:(?:\\[\\s*\\]\\s*)+)?)\\s*::\\s*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)")) != null) {
                ClassNode classNode = ClassNode.parse(ctx, methodMatcher.group(1), false);
                String methodName = methodMatcher.group(2);
                if (complete && ctx.isEOF()) {
                    Class<?> type = null;
                    try {
                        type = classNode.resolveClass(session);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (type != null) {
                        HashSet<String> validMethodNames = new HashSet<String>();
                        validMethodNames.add("new");
                        for (Method method : type.getMethods()) {
                            validMethodNames.add(method.getName());
                        }
                        if (!validMethodNames.contains(methodName)) {
                            throw new ParseException(ctx, "unknown method `" + methodName + "()' in " + type).addCompletions(ParseUtil.complete(validMethodNames, methodName));
                        }
                    }
                }
                return new UnboundMethodReferenceNode(classNode, methodName);
            }
            if (complete && (nameDotMatcher = ctx.tryPattern("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\s*(\\.\\s*)?$")) != null) {
                String className = nameDotMatcher.group(1);
                if (nameDotMatcher.group(2) == null) {
                    throw new ParseException(ctx).addCompletions(AtomExprParser.getClassNameCompletions(session, className));
                }
                try {
                    Class<?> clazz = session.resolveClass(className, false);
                    throw new ParseException(ctx).addCompletions(AtomExprParser.getStaticMemberCompletions(clazz, ""));
                }
                catch (IllegalArgumentException e4) {
                    ctx.setIndex(start);
                }
            }
            if ((staticMatcher = ctx.tryPattern("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\s*\\.\\s*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)")) != null) {
                Class cl;
                StringBuilder idents = new StringBuilder(staticMatcher.group(1));
                String member = staticMatcher.group(2);
                ArrayList<Integer> indexList = new ArrayList<Integer>();
                ArrayList<Class> classList = new ArrayList<Class>();
                ArrayList<String> memberList = new ArrayList<String>();
                while (true) {
                    try {
                        cl = session.resolveClass(idents.toString(), false);
                    }
                    catch (IllegalArgumentException e5) {
                        cl = null;
                    }
                    classList.add(cl);
                    indexList.add(ctx.getIndex());
                    memberList.add(member);
                    Matcher matcher = ctx.tryPattern("\\s*\\.\\s*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)");
                    if (matcher == null) break;
                    idents.append('.').append(member);
                    member = matcher.group(1);
                }
                ctx.skipWhitespace();
                for (int i = classList.size() - 1; i >= 0; --i) {
                    cl = (Class)classList.get(i);
                    if (cl == null) continue;
                    ctx.setIndex(((Integer)indexList.get(i)).intValue());
                    member = (String)memberList.get(i);
                    break;
                }
                if (cl == null) {
                    ParseException e6 = new ParseException(ctx, "unknown class `" + idents + "'");
                    if (complete && ctx.isEOF()) {
                        e6.addCompletions(AtomExprParser.getClassNameCompletions(session, idents.toString()));
                    }
                    throw e6;
                }
                if (complete && ctx.isEOF()) {
                    throw new ParseException(ctx).addCompletions(AtomExprParser.getStaticMemberCompletions(cl, member));
                }
                if (ctx.tryPattern("\\s*\\(") != null) {
                    return new MethodInvokeNode(cl, member, AtomExprParser.parseParams(session, ctx, complete));
                }
                try {
                    return new ConstNode(new StaticFieldValue(AtomExprParser.findField(cl, member, true)));
                }
                catch (NoSuchFieldException e7) {
                    throw new ParseException(ctx, e7.getMessage());
                }
            }
            throw new ParseException(ctx);
        }
    }

    static Field findField(Class<?> cl, String fieldName, boolean isStatic) throws NoSuchFieldException {
        Field bestMatch = AtomExprParser.findField(cl, fieldName, null, isStatic);
        if (bestMatch == null) {
            throw new NoSuchFieldException("class `" + cl.getName() + "' has no field named `" + fieldName + "'");
        }
        if ((bestMatch.getModifiers() & 8) != 0 != isStatic) {
            throw new NoSuchFieldException("field `" + fieldName + "' in class `" + cl.getName() + "' is not " + (isStatic ? "a static" : "an instance") + " field");
        }
        try {
            bestMatch.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return bestMatch;
    }

    private static Field findField(Class<?> cl, String fieldName, Field bestSoFar, boolean isStatic) {
        int mask = 8;
        int flags = isStatic ? 8 : 0;
        for (Field field : cl.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            if (bestSoFar == null || (bestSoFar.getModifiers() & 8) != flags) {
                bestSoFar = field;
            }
            if (bestSoFar == null || (bestSoFar.getModifiers() & 8) != flags) break;
            return bestSoFar;
        }
        if (cl.getSuperclass() != null) {
            bestSoFar = AtomExprParser.findField(cl.getSuperclass(), fieldName, bestSoFar, isStatic);
        }
        for (AnnotatedElement annotatedElement : cl.getInterfaces()) {
            bestSoFar = AtomExprParser.findField(annotatedElement, fieldName, bestSoFar, isStatic);
        }
        return bestSoFar;
    }

    static Stream<String> getClassNameCompletions(ParseSession session, String name) {
        try {
            return new ClassNameCompletion(name).findCompletions(session);
        }
        catch (NoClassDefFoundError e) {
            return Stream.empty();
        }
    }

    static Stream<String> getStaticMemberCompletions(Class<?> cl, String name) {
        TreeSet<String> names = new TreeSet<String>();
        AtomExprParser.getMemberNames(cl, names, true);
        names.add("class");
        return ParseUtil.complete(names, name);
    }

    static Stream<String> getInstanceMemberCompletions(Class<?> cl, String name) {
        TreeSet<String> names = new TreeSet<String>();
        AtomExprParser.getMemberNames(cl, names, false);
        AtomExprParser.getBeanPropertyNames(cl, names);
        if (cl.isArray()) {
            names.add("length");
        }
        return ParseUtil.complete(names, name);
    }

    private static Iterable<String> getMemberNames(Class<?> cl, TreeSet<String> names, boolean isStatic) {
        int mask = 8;
        int flags = isStatic ? 8 : 0;
        for (Field field : cl.getDeclaredFields()) {
            if ((field.getModifiers() & mask) != flags) continue;
            names.add(field.getName());
        }
        mask |= 1;
        flags |= 1;
        for (AccessibleObject accessibleObject : cl.getDeclaredMethods()) {
            if ((((Method)accessibleObject).getModifiers() & mask) != flags) continue;
            names.add(((Method)accessibleObject).getName() + "(");
        }
        if (cl.getSuperclass() != null) {
            AtomExprParser.getMemberNames(cl.getSuperclass(), names, isStatic);
        }
        for (AnnotatedElement annotatedElement : cl.getInterfaces()) {
            AtomExprParser.getMemberNames(annotatedElement, names, isStatic);
        }
        return names;
    }

    static List<Node> parseParams(ParseSession session, ParseContext ctx, boolean complete) {
        ArrayList<Node> params = new ArrayList<Node>();
        SpaceParser spaceParser = new SpaceParser();
        spaceParser.parse(ctx, complete);
        if (ctx.tryLiteral(")")) {
            return params;
        }
        while (true) {
            params.add(ExprParser.INSTANCE.parse(session, ctx, complete));
            spaceParser.parse(ctx, complete);
            if (ctx.tryLiteral(")")) break;
            if (!ctx.tryLiteral(",")) {
                throw new ParseException(ctx, "expected `,'").addCompletion(", ");
            }
            spaceParser.parse(ctx, complete);
        }
        return params;
    }

    static void getBeanPropertyNames(Class<?> cl, TreeSet<String> names) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(cl);
        }
        catch (IntrospectionException e) {
            return;
        }
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            if (propertyDescriptor instanceof IndexedPropertyDescriptor || propertyDescriptor.getReadMethod() == null) continue;
            names.add(propertyDescriptor.getName());
        }
    }

    private static class ClassNameCompletion {
        private final String prefix;
        private final boolean hasDot;

        ClassNameCompletion(String prefix) {
            this.prefix = prefix;
            this.hasDot = prefix.indexOf(46) != -1;
        }

        public Stream<String> findCompletions(ParseSession session) {
            HashSet<String> patterns = new HashSet<String>();
            if (!this.hasDot) {
                for (String mport : session.getImports()) {
                    if ((mport = mport.replace('.', '/')).length() > 1 && mport.charAt(mport.length() - 2) == '/' && mport.charAt(mport.length() - 1) == '*') {
                        patterns.add("classpath*:" + mport.substring(0, mport.length() - 1) + this.prefix + "*.class");
                        continue;
                    }
                    if (mport.lastIndexOf(47) == -1 || !mport.substring(mport.lastIndexOf(47) + 1).startsWith(this.prefix)) continue;
                    patterns.add("classpath*:" + mport + ".class");
                }
            } else {
                String path = this.prefix.replace('.', '/');
                patterns.add("classpath*:" + path + "*.class");
            }
            HashSet<String> classNames = new HashSet<String>();
            for (String pattern : patterns) {
                Resource[] resources;
                try {
                    resources = new PathMatchingResourcePatternResolver().getResources(pattern);
                }
                catch (IOException e) {
                    continue;
                }
                for (Resource resource : resources) {
                    int dollar;
                    int dot;
                    String name;
                    if (this.hasDot) {
                        String uri;
                        try {
                            uri = resource.getURI().toString();
                        }
                        catch (IOException e) {
                            continue;
                        }
                        int npos = uri.lastIndexOf(this.prefix.replace('.', '/'));
                        name = uri.substring(npos).replace('/', '.');
                    } else {
                        name = resource.getFilename();
                    }
                    if (name.endsWith(".class")) {
                        name = name.substring(0, name.length() - 6);
                    }
                    if ((dot = name.indexOf(46, this.prefix.length())) != -1) {
                        name = name.substring(0, dot);
                    }
                    if ((dollar = name.indexOf(36, this.prefix.length())) != -1) {
                        name = name.substring(0, dollar);
                    }
                    classNames.add(name);
                }
            }
            return ParseUtil.complete(classNames, this.prefix);
        }
    }
}

