/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AbstractValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.MethodUtil;

public class BeanPropertyValue
extends AbstractValue {
    protected final Object bean;
    protected final String name;
    protected final Method getter;

    public BeanPropertyValue(Object bean, String name, Method getter) {
        Preconditions.checkArgument((bean != null ? 1 : 0) != 0, (Object)"null bean");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        Preconditions.checkArgument((getter != null ? 1 : 0) != 0, (Object)"null getter");
        this.bean = bean;
        this.name = name;
        this.getter = getter;
    }

    @Override
    public Object get(ParseSession session) {
        try {
            return MethodUtil.invokeRefreshed(this.getter, this.bean, new Object[0]);
        }
        catch (Exception e) {
            Exception t = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            throw new EvalException("error reading property `" + this.name + "' from object of type " + this.bean.getClass().getName() + ": " + t, t);
        }
    }

    @Override
    public Class<?> getType(ParseSession session) {
        return this.getter.getReturnType();
    }
}

