/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.SpaceParser;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Op;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.util.ParseContext;

public abstract class BinaryExprParser
implements Parser<Node> {
    private final SpaceParser spaceParser = new SpaceParser();
    private final Parser<? extends Node> lowerLevel;
    private final boolean leftAssociative;
    private final List<Op> ops;

    protected BinaryExprParser(Parser<? extends Node> lowerLevel, boolean leftAssociative, Op ... ops) {
        Preconditions.checkArgument((lowerLevel != null ? 1 : 0) != 0, (Object)"null lowerLevel");
        Preconditions.checkArgument((ops != null && ops.length > 0 ? 1 : 0) != 0, (Object)"null/empty ops");
        this.lowerLevel = lowerLevel;
        this.leftAssociative = leftAssociative;
        this.ops = Arrays.asList(ops);
    }

    protected BinaryExprParser(Parser<? extends Node> lowerLevel, Op ... ops) {
        this(lowerLevel, true, ops);
    }

    @Override
    public Node parse(ParseSession session, ParseContext ctx, boolean complete) {
        Node node;
        ArrayList<Node> nodeList = new ArrayList<Node>(2);
        ArrayList<Op> opList = new ArrayList<Op>(1);
        nodeList.add(this.lowerLevel.parse(session, ctx, complete));
        while (true) {
            Node rhs;
            this.spaceParser.parse(ctx, complete);
            int mark = ctx.getIndex();
            Op op = null;
            for (Op candidate : this.ops) {
                if (!ctx.tryLiteral(candidate.getSymbol())) continue;
                op = candidate;
                break;
            }
            if (op == null) break;
            this.spaceParser.parse(ctx, complete);
            try {
                rhs = this.lowerLevel.parse(session, ctx, complete);
            }
            catch (ParseException e) {
                if (complete && !e.getCompletions().isEmpty()) {
                    throw e;
                }
                ctx.setIndex(mark);
                break;
            }
            nodeList.add(rhs);
            opList.add(op);
        }
        if (nodeList.size() == 1) {
            return (Node)nodeList.get(0);
        }
        if (this.leftAssociative) {
            node = this.createNode((Op)((Object)opList.get(0)), (Node)nodeList.get(0), (Node)nodeList.get(1));
            for (int i = 1; i < nodeList.size() - 1; ++i) {
                node = this.createNode((Op)((Object)opList.get(i)), node, (Node)nodeList.get(i + 1));
            }
        } else {
            int max = nodeList.size();
            node = this.createNode((Op)((Object)opList.get(max - 2)), (Node)nodeList.get(max - 2), (Node)nodeList.get(max - 1));
            for (int i = max - 3; i >= 0; --i) {
                node = this.createNode((Op)((Object)opList.get(i)), (Node)nodeList.get(i), node);
            }
        }
        return node;
    }

    protected Node createNode(final Op op, final Node lhs, final Node rhs) {
        return new Node(){

            @Override
            public Value evaluate(ParseSession session) {
                return op.apply(session, lhs.evaluate(session), rhs.evaluate(session));
            }

            @Override
            public Class<?> getType(ParseSession session) {
                Class<?> rtype;
                Class<?> ltype = lhs.getType(session);
                return ltype == (rtype = rhs.getType(session)) ? ltype : Object.class;
            }
        };
    }
}

