/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.ConstNode;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.MethodReferenceNode;
import org.jsimpledb.parse.expr.MethodUtil;
import org.jsimpledb.parse.expr.Node;

public class BoundMethodReferenceNode
extends MethodReferenceNode {
    private final Node node;

    public BoundMethodReferenceNode(Node node, String name) {
        super(name);
        Preconditions.checkArgument((node != null ? 1 : 0) != 0, (Object)"null node");
        this.node = node;
    }

    @Override
    public <T> Node resolve(ParseSession session, TypeToken<T> type) {
        Object target = this.node.evaluate(session).checkNotNull(session, "method " + this.name + "() invocation");
        Method shape = MethodUtil.findFunctionalMethod(type.getRawType());
        Method method = MethodUtil.findMatchingMethod(target.getClass(), this.name, true, shape.getGenericParameterTypes(), shape.getReturnType() != Void.TYPE ? shape.getReturnType() : null, false);
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        try {
            MethodHandle handle = lookup.unreflect(method).bindTo(target);
            return new ConstNode(new ConstValue(MethodHandleProxies.asInterfaceInstance(type.getRawType(), handle)));
        }
        catch (Exception e) {
            throw new EvalException("failed to resolve method `" + this.name + "' in object of type " + target.getClass().getName(), e);
        }
    }
}

