/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import java.util.regex.Matcher;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.SpaceParser;
import org.jsimpledb.parse.expr.CastNode;
import org.jsimpledb.parse.expr.ClassNode;
import org.jsimpledb.parse.expr.LambdaExprParser;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.UnaryExprParser;
import org.jsimpledb.util.ParseContext;

public class CastExprParser
implements Parser<Node> {
    public static final CastExprParser INSTANCE = new CastExprParser();
    private final SpaceParser spaceParser = new SpaceParser();

    @Override
    public Node parse(ParseSession session, ParseContext ctx, boolean complete) {
        int start = ctx.getIndex();
        Matcher castMatcher = ctx.tryPattern("(?s)\\(\\s*((?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*(?:\\.\\s*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*)\\s*(?:(?:\\[\\s*\\]\\s*)+)?)\\s*\\)\\s*(?=.)");
        while (castMatcher != null) {
            String className = castMatcher.group(1).replaceAll("\\s", "");
            try {
                Node target = this.parse(session, ctx, complete);
                ctx.skipWhitespace();
                return new CastNode(new ClassNode(className, true), target);
            }
            catch (ParseException e) {
                ctx.setIndex(start);
            }
        }
        try {
            return LambdaExprParser.INSTANCE.parse(session, ctx, complete);
        }
        catch (ParseException e) {
            ctx.setIndex(start);
            return UnaryExprParser.INSTANCE.parse(session, ctx, complete);
        }
    }
}

