/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.util.ParseContext;

public class ClassNode
implements Node {
    private final String className;
    private final boolean allowPrimitive;

    public ClassNode(String className, boolean allowPrimitive) {
        Preconditions.checkArgument((className != null ? 1 : 0) != 0, (Object)"null className");
        this.className = className;
        this.allowPrimitive = allowPrimitive;
    }

    @Override
    public Value evaluate(ParseSession session) {
        return new ConstValue(this.resolveClass(session));
    }

    @Override
    public Class<?> getType(ParseSession session) {
        return Class.class;
    }

    public Class<?> resolveClass(ParseSession session) {
        try {
            return session.resolveClass(this.className, this.allowPrimitive);
        }
        catch (IllegalArgumentException e) {
            throw new EvalException(e.getMessage());
        }
    }

    public String getClassName() {
        return this.className;
    }

    public static ClassNode parse(ParseContext ctx, String name, boolean allowPrimitive) {
        if ((name = name.replaceAll("\\s+", "")).startsWith("void[]")) {
            throw new ParseException(ctx, "invalid void array type");
        }
        int dims = 0;
        for (int pos = name.length(); pos >= 2 && name.charAt(pos - 2) == '[' && name.charAt(pos - 1) == ']'; pos -= 2) {
            ++dims;
        }
        if (dims > 255) {
            throw new ParseException(ctx, "too many array dimensions (" + dims + " > 255)");
        }
        return new ClassNode(name, allowPrimitive);
    }
}

