/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AbstractInvokeNode;
import org.jsimpledb.parse.expr.ClassNode;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.MethodUtil;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Value;

public class ConstructorInvokeNode
extends AbstractInvokeNode<Constructor<?>> {
    private final ClassNode classNode;

    public ConstructorInvokeNode(ClassNode classNode, List<Node> paramNodes) {
        super(paramNodes);
        Preconditions.checkArgument((classNode != null ? 1 : 0) != 0, (Object)"null classNode");
        this.classNode = classNode;
    }

    @Override
    public Value evaluate(ParseSession session) {
        Object result;
        Class<?> cl = this.classNode.resolveClass(session);
        if (cl.isPrimitive() || (cl.getModifiers() & 0x400) != 0) {
            throw new EvalException("invalid instantiation of " + cl);
        }
        AbstractInvokeNode.ParamInfo paramInfo = this.evaluateParams(session);
        Constructor<?> constructor = MethodUtil.findMatchingConstructor(cl, paramInfo.getParamTypes());
        this.fixupVarArgs(paramInfo, constructor);
        this.fixupTypeInferringNodes(session, paramInfo, constructor);
        try {
            result = constructor.newInstance(paramInfo.getParams());
        }
        catch (Exception e) {
            Exception t = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            throw new EvalException("error invoking constructor " + cl.getSimpleName() + "(): " + t, t);
        }
        return new ConstValue(result);
    }

    @Override
    public Class<?> getType(ParseSession session) {
        try {
            return this.classNode.resolveClass(session);
        }
        catch (EvalException e) {
            return Object.class;
        }
    }
}

