/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import java.lang.reflect.Array;
import java.util.List;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.expr.AbstractArrayNode;
import org.jsimpledb.parse.expr.ClassNode;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Value;

public class EmptyArrayNode
extends AbstractArrayNode {
    private final List<Node> dimensionList;

    public EmptyArrayNode(ClassNode baseTypeNode, List<Node> dimensionList) {
        super(baseTypeNode, dimensionList.size());
        this.dimensionList = dimensionList;
    }

    @Override
    public Value evaluate(ParseSession session) {
        Class<?> elemType = ParseUtil.getArrayClass(this.getBaseType(session), this.numDimensions - 1);
        return new ConstValue(EmptyArrayNode.createEmpty(session, elemType, this.dimensionList));
    }

    private static Object createEmpty(ParseSession session, Class<?> elemType, List<Node> dims) {
        int length = dims.get(0).evaluate(session).checkIntegral(session, "array creation");
        Object array = Array.newInstance(elemType, length);
        List<Node> remainingDims = dims.subList(1, dims.size());
        if (!remainingDims.isEmpty() && remainingDims.get(0) != null) {
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, EmptyArrayNode.createEmpty(session, elemType.getComponentType(), remainingDims));
            }
        }
        return array;
    }
}

