/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import org.jsimpledb.core.Field;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AbstractValue;
import org.jsimpledb.parse.expr.EvalException;

public class FieldValue
extends AbstractValue {
    protected final ObjId id;
    protected final Field<?> field;

    public FieldValue(ObjId id, Field<?> field) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (Object)"null field");
        this.id = id;
        this.field = field;
    }

    @Override
    public Object get(ParseSession session) {
        try {
            return this.field.getValue(session.getTransaction(), this.id);
        }
        catch (Exception e) {
            throw new EvalException("error reading field `" + this.field.getName() + "' from object " + this.id + ": " + (e.getMessage() != null ? e.getMessage() : e));
        }
    }

    @Override
    public Class<?> getType(ParseSession session) {
        return this.field.getTypeToken().getRawType();
    }
}

