/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.expr.ExprParser;
import org.jsimpledb.parse.expr.LambdaNode;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.util.ParseContext;

public class LambdaExprParser
implements Parser<LambdaNode> {
    public static final LambdaExprParser INSTANCE = new LambdaExprParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LambdaNode parse(ParseSession session, ParseContext ctx, boolean complete) {
        Node body;
        String id = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
        Matcher matcher = ctx.tryPattern("((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)|\\(\\s*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*(,\\s*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*)*)?\\))\\s*->\\s*");
        if (matcher == null) {
            throw new ParseException(ctx);
        }
        LinkedHashMap<Object, LambdaNode.Param> paramMap = new LinkedHashMap<Object, LambdaNode.Param>(4);
        if (matcher.group(2) != null) {
            String[] name = matcher.group(2);
            paramMap.put(name, new LambdaNode.Param((String)name));
        } else if (matcher.group(3) != null) {
            for (String name : matcher.group(3).trim().split("\\s*,\\s*")) {
                if (paramMap.containsKey(name)) {
                    throw new ParseException(ctx, "duplicate lambda parameter `" + name + "'");
                }
                paramMap.put(name, new LambdaNode.Param(name));
            }
        }
        Parser<? extends Node> previousParser = session.getIdentifierParser();
        session.setIdentifierParser((session2, ctx2, complete2) -> {
            Matcher identMatcher = ctx2.tryPattern("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
            if (identMatcher == null) {
                throw new ParseException(ctx2);
            }
            String name = identMatcher.group();
            LambdaNode.Param paramNode = (LambdaNode.Param)paramMap.get(name);
            if (paramNode == null) {
                throw new ParseException(ctx2, "unknown lambda parameter `" + name + "'").addCompletions(ParseUtil.complete(paramMap.keySet(), name));
            }
            return paramNode;
        });
        try {
            body = ExprParser.INSTANCE.parse(session, ctx, complete);
        }
        finally {
            session.setIdentifierParser(previousParser);
        }
        return new LambdaNode(new ArrayList<LambdaNode.Param>(paramMap.values()), body);
    }
}

