/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.SpaceParser;
import org.jsimpledb.parse.expr.AbstractArrayNode;
import org.jsimpledb.parse.expr.ClassNode;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.ExprParser;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.util.ParseContext;

public class LiteralArrayNode
extends AbstractArrayNode {
    private final List<?> initialValue;

    public LiteralArrayNode(ClassNode baseTypeNode, int numDimensions, List<?> initialValue) {
        super(baseTypeNode, numDimensions);
        this.initialValue = initialValue;
    }

    @Override
    public Value evaluate(ParseSession session) {
        Class<?> elemType = ParseUtil.getArrayClass(this.getBaseType(session), this.numDimensions - 1);
        return new ConstValue(LiteralArrayNode.createLiteral(session, elemType, this.initialValue));
    }

    private static Object createLiteral(ParseSession session, Class<?> elemType, List<?> values) {
        int length = values.size();
        Object array = Array.newInstance(elemType, length);
        for (int i = 0; i < length; ++i) {
            if (elemType.isArray()) {
                Array.set(array, i, LiteralArrayNode.createLiteral(session, elemType.getComponentType(), (List)values.get(i)));
                continue;
            }
            try {
                Array.set(array, i, ((Node)values.get(i)).evaluate(session).get(session));
                continue;
            }
            catch (Exception e) {
                throw new EvalException("error setting array value: " + e, e);
            }
        }
        return array;
    }

    public static List<?> parseArrayLiteral(ParseSession session, ParseContext ctx, boolean complete, int dims) {
        Preconditions.checkArgument((dims >= 1 ? 1 : 0) != 0, (Object)"dims < 1");
        SpaceParser spaceParser = new SpaceParser();
        ArrayList<Object> list = new ArrayList<Object>();
        spaceParser.parse(ctx, complete);
        if (!ctx.tryLiteral("{")) {
            throw new ParseException(ctx).addCompletion("{ ");
        }
        spaceParser.parse(ctx, complete);
        if (ctx.tryLiteral("}")) {
            return list;
        }
        while (true) {
            list.add(dims > 1 ? LiteralArrayNode.parseArrayLiteral(session, ctx, complete, dims - 1) : ExprParser.INSTANCE.parse(session, ctx, complete));
            ctx.skipWhitespace();
            if (ctx.tryLiteral("}")) break;
            if (!ctx.tryLiteral(",")) {
                throw new ParseException(ctx, "expected `,'").addCompletion(", ");
            }
            spaceParser.parse(ctx, complete);
        }
        return list;
    }
}

